/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Iterator;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.neoforged.neoforge.common.util.TriState;
import org.jetbrains.annotations.Nullable;
import twilightforest.beanification.Autowired;
import twilightforest.block.CloudBlock;
import twilightforest.block.WroughtIronFenceBlock;
import twilightforest.client.FoliageColorHandler;
import twilightforest.config.TFConfig;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDataAttachments;
import twilightforest.init.TFDataComponents;
import twilightforest.init.custom.ChunkBlanketProcessors;
import twilightforest.util.ArmorUtil;
import twilightforest.util.WorldUtil;
import twilightforest.util.multiparts.MultipartEntityUtil;
import twilightforest.world.components.structures.CustomDensitySource;
import twilightforest.world.components.structures.util.CustomStructureData;

public class ASMHooks {
    @Autowired
    private static ArmorUtil armorUtil;
    @Autowired
    private static MultipartEntityUtil multipartEntityUtil;
    @Autowired
    private static FoliageColorHandler foliageColorHandler;

    public static float modifyArmorVisibility(float o, LivingEntity entity) {
        return o - armorUtil.getShroudedArmorPercentage(entity);
    }

    public static boolean cancelArmorRendering(boolean o, ItemStack stack) {
        if (o && stack.get(TFDataComponents.EMPERORS_CLOTH) != null) {
            return false;
        }
        return o;
    }

    public static ObjectListIterator<DensityFunction> gatherCustomTerrain(StructureManager structureManager, ChunkPos chunkPos) {
        ObjectArrayList customStructureTerraforms = new ObjectArrayList(10);
        for (StructureStart structureStart : structureManager.startsForStructure(chunkPos, s -> s instanceof CustomDensitySource)) {
            Structure structure = structureStart.getStructure();
            if (!(structure instanceof CustomDensitySource)) continue;
            CustomDensitySource customDensitySource = (CustomDensitySource)structure;
            customStructureTerraforms.add((Object)customDensitySource.getStructureTerraformer(chunkPos, structureStart));
        }
        return customStructureTerraforms.iterator();
    }

    public static double getCustomDensity(double o, DensityFunction.FunctionContext context, @Nullable ObjectListIterator<DensityFunction> customDensities) {
        if (customDensities == null) {
            return o;
        }
        double newDensity = 0.0;
        while (customDensities.hasNext()) {
            newDensity += ((DensityFunction)customDensities.next()).compute(context);
        }
        customDensities.back(Integer.MAX_VALUE);
        return o + newDensity;
    }

    public static Component modifyWrittenBookName(Component component, ItemStack stack) {
        if (stack.has(TFDataComponents.TRANSLATABLE_BOOK)) {
            return Component.translatable((String)component.getString());
        }
        return component;
    }

    public static void chunkBlanketing(ChunkAccess chunkAccess, WorldGenRegion worldGenRegion) {
        ChunkBlanketProcessors.chunkBlanketing(chunkAccess, worldGenRegion);
    }

    public static boolean isRainingAt(boolean isRaining, Level level, BlockPos pos) {
        if (!isRaining && TFConfig.commonCloudBlockPrecipitationDistance > 0) {
            LevelChunk chunk = level.getChunkAt(pos);
            for (int y = pos.getY(); y < pos.getY() + TFConfig.commonCloudBlockPrecipitationDistance; ++y) {
                CloudBlock cloudBlock;
                BlockPos newPos = pos.atY(y);
                BlockState state = chunk.getBlockState(newPos);
                Block block = state.getBlock();
                if (block instanceof CloudBlock && (cloudBlock = (CloudBlock)block).getCurrentPrecipitation(newPos, level, level.getRainLevel(1.0f)).getLeft() == Biome.Precipitation.RAIN) {
                    return true;
                }
                if (!Heightmap.Types.MOTION_BLOCKING.isOpaque().test(state)) continue;
                return false;
            }
        }
        return isRaining;
    }

    public static StructureStart loadStaticStart(StructureStart start, PiecesContainer piecesContainer, CompoundTag nbt) {
        Structure structure = start.getStructure();
        if (structure instanceof CustomStructureData) {
            CustomStructureData s = (CustomStructureData)structure;
            return s.forDeserialization(start.getStructure(), start.getChunkPos(), start.getReferences(), piecesContainer, nbt);
        }
        return start;
    }

    public static int resolveFoliageColor(int o, Biome biome, double x, double z) {
        return foliageColorHandler.get(o, biome, x, z);
    }

    public static boolean leashFenceKnotSurvives(boolean o, LeashFenceKnotEntity entity) {
        if (o) {
            return true;
        }
        BlockState fenceState = entity.level().getBlockState(entity.getPos());
        return fenceState.is(TFBlocks.WROUGHT_IRON_FENCE) && fenceState.getValue(WroughtIronFenceBlock.POST) != WroughtIronFenceBlock.PostState.NONE;
    }

    @Nullable
    public static Pair<BlockPos, Holder<Structure>> resolveNearestNonRandomSpreadMapStructure(@Nullable Pair<BlockPos, Holder<Structure>> o, ServerLevel level, HolderSet<Structure> targetStructures, BlockPos pos, int searchRadius, boolean skipKnownStructures) {
        return WorldUtil.findNearestMapLandmark(level, targetStructures, pos, searchRadius, skipKnownStructures).orElse(o);
    }

    public static Iterator<Entity> resolveEntitiesForRendering(Iterator<Entity> iter) {
        return multipartEntityUtil.injectTFPartEntities(iter);
    }

    @Nullable
    public static EntityRenderer<?> resolveEntityRenderer(@Nullable EntityRenderer<?> renderer, Entity entity) {
        return multipartEntityUtil.tryLookupTFPartRenderer(renderer, entity);
    }

    public static Entity sendDirtyEntityData(Entity entity) {
        return multipartEntityUtil.sendDirtyMultipartEntityData(entity);
    }

    public static TriState modifySoilDecisionForMushroomBlockSurvivability(TriState o, LevelReader level, BlockPos pos) {
        if (!o.isDefault()) {
            return o;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0 || !level.getBlockState(pos.offset(x, -1, z)).is(TFBlocks.TWILIGHT_PORTAL)) continue;
                return TriState.TRUE;
            }
        }
        return o;
    }

    public static boolean overrideStayCloseToHolder(boolean prior, PathfinderMob mob) {
        return prior && !mob.hasData(TFDataAttachments.LEASH_PATHFINDER_OVERRIDE);
    }
}

