/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.raytrace;

import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class Perspective {
    private Supplier<Vec3> pos;
    private Supplier<Vector3f> lookVector;

    public Perspective(Supplier<Vec3> pos, Supplier<Vector3f> lookVector) {
        this.pos = pos;
        this.lookVector = lookVector;
    }

    public Vec3 getPosition() {
        return this.pos.get();
    }

    public Vector3f getLookVector() {
        return this.lookVector.get();
    }

    public static Perspective fromCamera(Camera camera) {
        return new Perspective(() -> ((Camera)camera).getPosition(), () -> ((Camera)camera).getLookVector());
    }

    public static Perspective fromEntity(Entity entity) {
        return new Perspective(() -> ((Entity)entity).getEyePosition(), () -> entity.getViewVector(0.0f).toVector3f());
    }
}

