/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.hnsw;

import guideme.internal.shaded.lucene.util.ArrayUtil;
import guideme.internal.shaded.lucene.util.hnsw.RandomVectorScorer;
import guideme.internal.shaded.lucene.util.hnsw.RandomVectorScorerSupplier;
import java.io.IOException;
import java.util.Arrays;

public class NeighborArray {
    private final boolean scoresDescOrder;
    private int size;
    private final float[] scores;
    private final int[] nodes;
    private int sortedNodeSize;

    public NeighborArray(int maxSize, boolean descOrder) {
        this.nodes = new int[maxSize];
        this.scores = new float[maxSize];
        this.scoresDescOrder = descOrder;
    }

    public void addInOrder(int newNode, float newScore) {
        assert (this.size == this.sortedNodeSize) : "cannot call addInOrder after addOutOfOrder";
        if (this.size == this.nodes.length) {
            throw new IllegalStateException("No growth is allowed");
        }
        if (this.size > 0) {
            float previousScore = this.scores[this.size - 1];
            assert (this.scoresDescOrder && previousScore >= newScore || !this.scoresDescOrder && previousScore <= newScore) : "Nodes are added in the incorrect order! Comparing " + newScore + " to " + Arrays.toString(ArrayUtil.copyOfSubArray(this.scores, 0, this.size));
        }
        this.nodes[this.size] = newNode;
        this.scores[this.size] = newScore;
        ++this.size;
        ++this.sortedNodeSize;
    }

    public void addOutOfOrder(int newNode, float newScore) {
        if (this.size == this.nodes.length) {
            throw new IllegalStateException("No growth is allowed");
        }
        this.scores[this.size] = newScore;
        this.nodes[this.size] = newNode;
        ++this.size;
    }

    public void addAndEnsureDiversity(int newNode, float newScore, int nodeId, RandomVectorScorerSupplier scorerSupplier) throws IOException {
        this.addOutOfOrder(newNode, newScore);
        if (this.size < this.nodes.length) {
            return;
        }
        this.removeIndex(this.findWorstNonDiverse(nodeId, scorerSupplier));
        assert (this.size == this.nodes.length - 1);
    }

    int[] sort(RandomVectorScorer scorer) throws IOException {
        if (this.size == this.sortedNodeSize) {
            return null;
        }
        assert (this.sortedNodeSize < this.size);
        int[] uncheckedIndexes = new int[this.size - this.sortedNodeSize];
        int count = 0;
        while (this.sortedNodeSize != this.size) {
            uncheckedIndexes[count] = this.insertSortedInternal(scorer);
            for (int i = 0; i < count; ++i) {
                if (uncheckedIndexes[i] < uncheckedIndexes[count]) continue;
                int n = i;
                uncheckedIndexes[n] = uncheckedIndexes[n] + 1;
            }
            ++count;
        }
        Arrays.sort(uncheckedIndexes);
        return uncheckedIndexes;
    }

    private int insertSortedInternal(RandomVectorScorer scorer) throws IOException {
        assert (this.sortedNodeSize < this.size) : "Call this method only when there's unsorted node";
        int tmpNode = this.nodes[this.sortedNodeSize];
        float tmpScore = this.scores[this.sortedNodeSize];
        if (Float.isNaN(tmpScore)) {
            tmpScore = scorer.score(tmpNode);
        }
        int insertionPoint = this.scoresDescOrder ? this.descSortFindRightMostInsertionPoint(tmpScore, this.sortedNodeSize) : this.ascSortFindRightMostInsertionPoint(tmpScore, this.sortedNodeSize);
        System.arraycopy(this.nodes, insertionPoint, this.nodes, insertionPoint + 1, this.sortedNodeSize - insertionPoint);
        System.arraycopy(this.scores, insertionPoint, this.scores, insertionPoint + 1, this.sortedNodeSize - insertionPoint);
        this.nodes[insertionPoint] = tmpNode;
        this.scores[insertionPoint] = tmpScore;
        ++this.sortedNodeSize;
        return insertionPoint;
    }

    void insertSorted(int newNode, float newScore) throws IOException {
        this.addOutOfOrder(newNode, newScore);
        this.insertSortedInternal(null);
    }

    public int size() {
        return this.size;
    }

    public int[] nodes() {
        return this.nodes;
    }

    public float[] scores() {
        return this.scores;
    }

    public void clear() {
        this.size = 0;
        this.sortedNodeSize = 0;
    }

    void removeLast() {
        --this.size;
        this.sortedNodeSize = Math.min(this.sortedNodeSize, this.size);
    }

    void removeIndex(int idx) {
        if (idx == this.size - 1) {
            this.removeLast();
            return;
        }
        System.arraycopy(this.nodes, idx + 1, this.nodes, idx, this.size - idx - 1);
        System.arraycopy(this.scores, idx + 1, this.scores, idx, this.size - idx - 1);
        if (idx < this.sortedNodeSize) {
            --this.sortedNodeSize;
        }
        --this.size;
    }

    public String toString() {
        return "NeighborArray[" + this.size + "]";
    }

    private int ascSortFindRightMostInsertionPoint(float newScore, int bound) {
        int insertionPoint = Arrays.binarySearch(this.scores, 0, bound, newScore);
        if (insertionPoint >= 0) {
            while (insertionPoint < bound - 1 && this.scores[insertionPoint + 1] == this.scores[insertionPoint]) {
                ++insertionPoint;
            }
            ++insertionPoint;
        } else {
            insertionPoint = -insertionPoint - 1;
        }
        return insertionPoint;
    }

    private int descSortFindRightMostInsertionPoint(float newScore, int bound) {
        int start = 0;
        int end = bound - 1;
        while (start <= end) {
            int mid = (start + end) / 2;
            if (this.scores[mid] < newScore) {
                end = mid - 1;
                continue;
            }
            start = mid + 1;
        }
        return start;
    }

    private int findWorstNonDiverse(int nodeOrd, RandomVectorScorerSupplier scorerSupplier) throws IOException {
        RandomVectorScorer scorer = scorerSupplier.scorer(nodeOrd);
        int[] uncheckedIndexes = this.sort(scorer);
        assert (uncheckedIndexes != null) : "We will always have something unchecked";
        int uncheckedCursor = uncheckedIndexes.length - 1;
        for (int i = this.size - 1; i > 0 && uncheckedCursor >= 0; --i) {
            if (this.isWorstNonDiverse(i, uncheckedIndexes, uncheckedCursor, scorerSupplier)) {
                return i;
            }
            if (i != uncheckedIndexes[uncheckedCursor]) continue;
            --uncheckedCursor;
        }
        return this.size - 1;
    }

    private boolean isWorstNonDiverse(int candidateIndex, int[] uncheckedIndexes, int uncheckedCursor, RandomVectorScorerSupplier scorerSupplier) throws IOException {
        float minAcceptedSimilarity = this.scores[candidateIndex];
        RandomVectorScorer scorer = scorerSupplier.scorer(this.nodes[candidateIndex]);
        if (candidateIndex == uncheckedIndexes[uncheckedCursor]) {
            for (int i = candidateIndex - 1; i >= 0; --i) {
                float neighborSimilarity = scorer.score(this.nodes[i]);
                if (!(neighborSimilarity >= minAcceptedSimilarity)) continue;
                return true;
            }
        } else {
            assert (candidateIndex > uncheckedIndexes[uncheckedCursor]);
            for (int i = uncheckedCursor; i >= 0; --i) {
                float neighborSimilarity = scorer.score(this.nodes[uncheckedIndexes[i]]);
                if (!(neighborSimilarity >= minAcceptedSimilarity)) continue;
                return true;
            }
        }
        return false;
    }
}

