/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.search.Explanation;
import guideme.internal.shaded.lucene.search.FieldDoc;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.LeafCollector;
import guideme.internal.shaded.lucene.search.Rescorer;
import guideme.internal.shaded.lucene.search.Score;
import guideme.internal.shaded.lucene.search.ScoreDoc;
import guideme.internal.shaded.lucene.search.Sort;
import guideme.internal.shaded.lucene.search.SortField;
import guideme.internal.shaded.lucene.search.TopDocs;
import guideme.internal.shaded.lucene.search.TopFieldCollector;
import guideme.internal.shaded.lucene.search.TopFieldCollectorManager;
import guideme.internal.shaded.lucene.search.TopFieldDocs;
import guideme.internal.shaded.lucene.search.TotalHits;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class SortRescorer
extends Rescorer {
    private final Sort sort;

    public SortRescorer(Sort sort) {
        this.sort = sort;
    }

    @Override
    public TopDocs rescore(IndexSearcher searcher, TopDocs firstPassTopDocs, int topN) throws IOException {
        ScoreDoc[] hits = (ScoreDoc[])firstPassTopDocs.scoreDocs.clone();
        Comparator<ScoreDoc> docIdComparator = Comparator.comparingInt(sd -> sd.doc);
        Arrays.sort(hits, docIdComparator);
        List<LeafReaderContext> leaves = searcher.getIndexReader().leaves();
        TopFieldCollector collector = new TopFieldCollectorManager(this.sort, topN, null, Integer.MAX_VALUE).newCollector();
        int readerUpto = -1;
        int endDoc = 0;
        int docBase = 0;
        LeafCollector leafCollector = null;
        Score score = new Score();
        for (int hitUpto = 0; hitUpto < hits.length; ++hitUpto) {
            ScoreDoc hit = hits[hitUpto];
            int docID = hit.doc;
            LeafReaderContext readerContext = null;
            while (docID >= endDoc) {
                readerContext = leaves.get(++readerUpto);
                endDoc = readerContext.docBase + readerContext.reader().maxDoc();
            }
            if (readerContext != null) {
                leafCollector = collector.getLeafCollector(readerContext);
                leafCollector.setScorer(score);
                docBase = readerContext.docBase;
            }
            score.score = hit.score;
            leafCollector.collect(docID - docBase);
        }
        TopFieldDocs rescoredDocs = collector.topDocs();
        assert (hits.length == rescoredDocs.scoreDocs.length);
        ScoreDoc[] rescoredDocsClone = (ScoreDoc[])rescoredDocs.scoreDocs.clone();
        Arrays.sort(rescoredDocsClone, docIdComparator);
        for (int i = 0; i < rescoredDocsClone.length; ++i) {
            rescoredDocsClone[i].score = hits[i].score;
        }
        return rescoredDocs;
    }

    @Override
    public Explanation explain(IndexSearcher searcher, Explanation firstPassExplanation, int docID) throws IOException {
        TopDocs oneHit = new TopDocs(new TotalHits(1L, TotalHits.Relation.EQUAL_TO), new ScoreDoc[]{new ScoreDoc(docID, firstPassExplanation.getValue().floatValue())});
        TopDocs hits = this.rescore(searcher, oneHit, 1);
        assert (hits.totalHits.value() == 1L);
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        Explanation first = Explanation.match(firstPassExplanation.getValue(), "first pass score", firstPassExplanation);
        subs.add(first);
        FieldDoc fieldDoc = (FieldDoc)hits.scoreDocs[0];
        SortField[] sortFields = this.sort.getSort();
        for (int i = 0; i < sortFields.length; ++i) {
            subs.add(Explanation.match((Number)Float.valueOf(0.0f), "sort field " + sortFields[i].toString() + " value=" + String.valueOf(fieldDoc.fields[i]), new Explanation[0]));
        }
        return Explanation.match((Number)Float.valueOf(0.0f), "sort field values for sort=" + this.sort.toString(), subs);
    }
}

