/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.search.IndriDisjunctionScorer;
import guideme.internal.shaded.lucene.search.IndriScorer;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.Scorer;
import java.io.IOException;
import java.util.List;

public class IndriAndScorer
extends IndriDisjunctionScorer {
    protected IndriAndScorer(List<Scorer> subScorers, ScoreMode scoreMode, float boost) throws IOException {
        super(subScorers, scoreMode, boost);
    }

    @Override
    public float score(List<Scorer> subScorers) throws IOException {
        int docId = this.docID();
        return this.scoreDoc(subScorers, docId);
    }

    @Override
    public float smoothingScore(List<Scorer> subScorers, int docId) throws IOException {
        return this.scoreDoc(subScorers, docId);
    }

    private float scoreDoc(List<Scorer> subScorers, int docId) throws IOException {
        double score = 0.0;
        double boostSum = 0.0;
        for (Scorer scorer : subScorers) {
            if (!(scorer instanceof IndriScorer)) continue;
            IndriScorer indriScorer = (IndriScorer)scorer;
            int scorerDocId = indriScorer.docID();
            double tempScore = 0.0;
            tempScore = docId == scorerDocId ? (double)indriScorer.score() : (double)indriScorer.smoothingScore(docId);
            score += (tempScore *= (double)indriScorer.getBoost());
            boostSum += (double)indriScorer.getBoost();
        }
        if (boostSum == 0.0) {
            return 0.0f;
        }
        return (float)(score / boostSum);
    }
}

