/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queryparser.surround.query;

import guideme.internal.shaded.lucene.index.IndexReader;
import guideme.internal.shaded.lucene.index.MultiTerms;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.queryparser.surround.query.SimpleTerm;
import guideme.internal.shaded.lucene.search.WildcardQuery;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.automaton.CompiledAutomaton;
import java.io.IOException;

public class SrndTruncQuery
extends SimpleTerm {
    private final String truncated;
    private final CompiledAutomaton compiled;

    public SrndTruncQuery(String truncated) {
        super(false);
        this.truncated = truncated;
        this.compiled = new CompiledAutomaton(WildcardQuery.toAutomaton(new Term(null, truncated), 10000), false, true, true);
    }

    public String getTruncated() {
        return this.truncated;
    }

    @Override
    public String toStringUnquoted() {
        return this.getTruncated();
    }

    @Override
    public void visitMatchingTerms(IndexReader reader, String fieldName, SimpleTerm.MatchingTermVisitor mtv) throws IOException {
        Terms terms = MultiTerms.getTerms(reader, fieldName);
        if (terms != null) {
            BytesRef br;
            TermsEnum termsEnum = this.compiled.getTermsEnum(terms);
            while ((br = termsEnum.next()) != null) {
                mtv.visitMatchingTerm(new Term(fieldName, BytesRef.deepCopyOf(br)));
            }
        }
    }
}

