/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queries.function.valuesource;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.queries.function.FunctionValues;
import guideme.internal.shaded.lucene.queries.function.ValueSource;
import guideme.internal.shaded.lucene.queries.function.docvalues.LongDocValues;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import java.io.IOException;
import java.util.Map;

public class SumTotalTermFreqValueSource
extends ValueSource {
    protected final String indexedField;

    public SumTotalTermFreqValueSource(String indexedField) {
        this.indexedField = indexedField;
    }

    public String name() {
        return "sumtotaltermfreq";
    }

    @Override
    public String description() {
        return this.name() + "(" + this.indexedField + ")";
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        return (FunctionValues)context.get(this);
    }

    @Override
    public void createWeight(Map<Object, Object> context, IndexSearcher searcher) throws IOException {
        long sumTotalTermFreq = 0L;
        for (LeafReaderContext readerContext : searcher.getTopReaderContext().leaves()) {
            Terms terms = Terms.getTerms(readerContext.reader(), this.indexedField);
            long v = terms.getSumTotalTermFreq();
            assert (v != -1L);
            sumTotalTermFreq += v;
        }
        final long ttf = sumTotalTermFreq;
        context.put(this, new LongDocValues(this, this){

            @Override
            public long longVal(int doc) {
                return ttf;
            }
        });
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() + this.indexedField.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        SumTotalTermFreqValueSource other = (SumTotalTermFreqValueSource)o;
        return this.indexedField.equals(other.indexedField);
    }
}

