/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.codecs.NormsProducer;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.FieldInvertState;
import guideme.internal.shaded.lucene.index.SegmentWriteState;
import guideme.internal.shaded.lucene.index.Sorter;
import guideme.internal.shaded.lucene.index.TermsHashPerField;
import guideme.internal.shaded.lucene.util.ByteBlockPool;
import guideme.internal.shaded.lucene.util.Counter;
import guideme.internal.shaded.lucene.util.IntBlockPool;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

abstract class TermsHash {
    final TermsHash nextTermsHash;
    final IntBlockPool intPool;
    final ByteBlockPool bytePool;
    ByteBlockPool termBytePool;
    final Counter bytesUsed;

    TermsHash(IntBlockPool.Allocator intBlockAllocator, ByteBlockPool.Allocator byteBlockAllocator, Counter bytesUsed, TermsHash nextTermsHash) {
        this.nextTermsHash = nextTermsHash;
        this.bytesUsed = bytesUsed;
        this.intPool = new IntBlockPool(intBlockAllocator);
        this.bytePool = new ByteBlockPool(byteBlockAllocator);
        if (nextTermsHash != null) {
            this.termBytePool = this.bytePool;
            nextTermsHash.termBytePool = this.bytePool;
        }
    }

    public void abort() {
        try {
            this.reset();
        }
        finally {
            if (this.nextTermsHash != null) {
                this.nextTermsHash.abort();
            }
        }
    }

    void reset() {
        this.intPool.reset(false, false);
        this.bytePool.reset(false, false);
    }

    void flush(Map<String, TermsHashPerField> fieldsToFlush, SegmentWriteState state, Sorter.DocMap sortMap, NormsProducer norms) throws IOException {
        if (this.nextTermsHash != null) {
            HashMap<String, TermsHashPerField> nextChildFields = new HashMap<String, TermsHashPerField>();
            for (Map.Entry<String, TermsHashPerField> entry : fieldsToFlush.entrySet()) {
                nextChildFields.put(entry.getKey(), entry.getValue().getNextPerField());
            }
            this.nextTermsHash.flush(nextChildFields, state, sortMap, norms);
        }
    }

    abstract TermsHashPerField addField(FieldInvertState var1, FieldInfo var2);

    void finishDocument(int docID) throws IOException {
        if (this.nextTermsHash != null) {
            this.nextTermsHash.finishDocument(docID);
        }
    }

    void startDocument() throws IOException {
        if (this.nextTermsHash != null) {
            this.nextTermsHash.startDocument();
        }
    }
}

