/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet;

import guideme.internal.shaded.lucene.index.DocValues;
import guideme.internal.shaded.lucene.index.IndexReader;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.OrdinalMap;
import guideme.internal.shaded.lucene.index.SortedSetDocValues;
import java.io.IOException;
import java.util.List;

public class StringDocValuesReaderState {
    final IndexReader reader;
    final String field;
    final OrdinalMap ordinalMap;

    public StringDocValuesReaderState(IndexReader reader, String field) throws IOException {
        this.reader = reader;
        this.field = field;
        this.ordinalMap = StringDocValuesReaderState.buildOrdinalMap(reader, field);
    }

    private static OrdinalMap buildOrdinalMap(IndexReader reader, String field) throws IOException {
        List<LeafReaderContext> leaves = reader.leaves();
        int leafCount = leaves.size();
        if (leafCount <= 1) {
            return null;
        }
        SortedSetDocValues[] docValues = new SortedSetDocValues[leafCount];
        for (int i = 0; i < leafCount; ++i) {
            LeafReaderContext context = reader.leaves().get(i);
            docValues[i] = DocValues.getSortedSet(context.reader(), field);
        }
        IndexReader.CacheHelper cacheHelper = reader.getReaderCacheHelper();
        IndexReader.CacheKey owner = cacheHelper == null ? null : cacheHelper.getKey();
        return OrdinalMap.build(owner, docValues, 0.25f);
    }

    public String toString() {
        return "StringDocValuesReaderState(field=" + this.field + " reader=" + String.valueOf(this.reader) + ")";
    }
}

