/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.codecs.lucene99;

import guideme.internal.shaded.lucene.codecs.CodecUtil;
import guideme.internal.shaded.lucene.codecs.KnnVectorsReader;
import guideme.internal.shaded.lucene.codecs.hnsw.FlatVectorsReader;
import guideme.internal.shaded.lucene.codecs.hnsw.HnswGraphProvider;
import guideme.internal.shaded.lucene.codecs.lucene99.Lucene99HnswVectorsFormat;
import guideme.internal.shaded.lucene.index.ByteVectorValues;
import guideme.internal.shaded.lucene.index.CorruptIndexException;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.FieldInfos;
import guideme.internal.shaded.lucene.index.FloatVectorValues;
import guideme.internal.shaded.lucene.index.IndexFileNames;
import guideme.internal.shaded.lucene.index.SegmentReadState;
import guideme.internal.shaded.lucene.index.VectorEncoding;
import guideme.internal.shaded.lucene.index.VectorSimilarityFunction;
import guideme.internal.shaded.lucene.internal.hppc.IntObjectHashMap;
import guideme.internal.shaded.lucene.search.KnnCollector;
import guideme.internal.shaded.lucene.store.ChecksumIndexInput;
import guideme.internal.shaded.lucene.store.DataInput;
import guideme.internal.shaded.lucene.store.IOContext;
import guideme.internal.shaded.lucene.store.IndexInput;
import guideme.internal.shaded.lucene.store.RandomAccessInput;
import guideme.internal.shaded.lucene.store.ReadAdvice;
import guideme.internal.shaded.lucene.util.Bits;
import guideme.internal.shaded.lucene.util.IOSupplier;
import guideme.internal.shaded.lucene.util.IOUtils;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;
import guideme.internal.shaded.lucene.util.hnsw.HnswGraph;
import guideme.internal.shaded.lucene.util.hnsw.HnswGraphSearcher;
import guideme.internal.shaded.lucene.util.hnsw.OrdinalTranslatedKnnCollector;
import guideme.internal.shaded.lucene.util.hnsw.RandomVectorScorer;
import guideme.internal.shaded.lucene.util.packed.DirectMonotonicReader;
import guideme.internal.shaded.lucene.util.quantization.QuantizedByteVectorValues;
import guideme.internal.shaded.lucene.util.quantization.QuantizedVectorsReader;
import guideme.internal.shaded.lucene.util.quantization.ScalarQuantizer;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class Lucene99HnswVectorsReader
extends KnnVectorsReader
implements QuantizedVectorsReader,
HnswGraphProvider {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(Lucene99HnswVectorsFormat.class);
    private final FlatVectorsReader flatVectorsReader;
    private final FieldInfos fieldInfos;
    private final IntObjectHashMap<FieldEntry> fields;
    private final IndexInput vectorIndex;
    public static final List<VectorSimilarityFunction> SIMILARITY_FUNCTIONS = List.of(VectorSimilarityFunction.EUCLIDEAN, VectorSimilarityFunction.DOT_PRODUCT, VectorSimilarityFunction.COSINE, VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene99HnswVectorsReader(SegmentReadState state, FlatVectorsReader flatVectorsReader) throws IOException {
        this.fields = new IntObjectHashMap();
        this.flatVectorsReader = flatVectorsReader;
        boolean success = false;
        this.fieldInfos = state.fieldInfos;
        String metaFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vem");
        int versionMeta = -1;
        try {
            try (ChecksumIndexInput meta = state.directory.openChecksumInput(metaFileName);){
                Throwable priorE = null;
                try {
                    versionMeta = CodecUtil.checkIndexHeader(meta, "Lucene99HnswVectorsFormatMeta", 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                    this.readFields(meta);
                }
                catch (Throwable exception) {
                    priorE = exception;
                }
                finally {
                    CodecUtil.checkFooter(meta, priorE);
                }
                this.vectorIndex = Lucene99HnswVectorsReader.openDataInput(state, versionMeta, "vex", "Lucene99HnswVectorsFormatIndex", state.context.withReadAdvice(ReadAdvice.RANDOM));
                success = true;
            }
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(this);
    }

    private Lucene99HnswVectorsReader(Lucene99HnswVectorsReader reader, FlatVectorsReader flatVectorsReader) {
        this.flatVectorsReader = flatVectorsReader;
        this.fieldInfos = reader.fieldInfos;
        this.fields = reader.fields;
        this.vectorIndex = reader.vectorIndex;
    }

    @Override
    public KnnVectorsReader getMergeInstance() {
        return new Lucene99HnswVectorsReader(this, this.flatVectorsReader.getMergeInstance());
    }

    @Override
    public void finishMerge() throws IOException {
        this.flatVectorsReader.finishMerge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexInput openDataInput(SegmentReadState state, int versionMeta, String fileExtension, String codecName, IOContext context) throws IOException {
        IndexInput indexInput;
        block4: {
            String fileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, fileExtension);
            IndexInput in = state.directory.openInput(fileName, context);
            boolean success = false;
            try {
                int versionVectorData = CodecUtil.checkIndexHeader(in, codecName, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                if (versionMeta != versionVectorData) {
                    throw new CorruptIndexException("Format versions mismatch: meta=" + versionMeta + ", " + codecName + "=" + versionVectorData, in);
                }
                CodecUtil.retrieveChecksum(in);
                success = true;
                indexInput = in;
                if (success) break block4;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(in);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(in);
        }
        return indexInput;
    }

    private void readFields(ChecksumIndexInput meta) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = this.fieldInfos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, meta);
            }
            FieldEntry fieldEntry = this.readField(meta, info);
            this.validateFieldEntry(info, fieldEntry);
            this.fields.put(info.number, fieldEntry);
            fieldNumber = meta.readInt();
        }
    }

    private void validateFieldEntry(FieldInfo info, FieldEntry fieldEntry) {
        int dimension = info.getVectorDimension();
        if (dimension != fieldEntry.dimension) {
            throw new IllegalStateException("Inconsistent vector dimension for field=\"" + info.name + "\"; " + dimension + " != " + fieldEntry.dimension);
        }
    }

    public static VectorSimilarityFunction readSimilarityFunction(DataInput input) throws IOException {
        int i = input.readInt();
        if (i < 0 || i >= SIMILARITY_FUNCTIONS.size()) {
            throw new IllegalArgumentException("invalid distance function: " + i);
        }
        return SIMILARITY_FUNCTIONS.get(i);
    }

    public static VectorEncoding readVectorEncoding(DataInput input) throws IOException {
        int encodingId = input.readInt();
        if (encodingId < 0 || encodingId >= VectorEncoding.values().length) {
            throw new CorruptIndexException("Invalid vector encoding id: " + encodingId, input);
        }
        return VectorEncoding.values()[encodingId];
    }

    private FieldEntry readField(IndexInput input, FieldInfo info) throws IOException {
        VectorEncoding vectorEncoding = Lucene99HnswVectorsReader.readVectorEncoding(input);
        VectorSimilarityFunction similarityFunction = Lucene99HnswVectorsReader.readSimilarityFunction(input);
        if (similarityFunction != info.getVectorSimilarityFunction()) {
            throw new IllegalStateException("Inconsistent vector similarity function for field=\"" + info.name + "\"; " + String.valueOf((Object)similarityFunction) + " != " + String.valueOf((Object)info.getVectorSimilarityFunction()));
        }
        return FieldEntry.create(input, vectorEncoding, info.getVectorSimilarityFunction());
    }

    @Override
    public long ramBytesUsed() {
        return SHALLOW_SIZE + this.fields.ramBytesUsed() + this.flatVectorsReader.ramBytesUsed();
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.flatVectorsReader.checkIntegrity();
        CodecUtil.checksumEntireFile(this.vectorIndex);
    }

    @Override
    public FloatVectorValues getFloatVectorValues(String field) throws IOException {
        return this.flatVectorsReader.getFloatVectorValues(field);
    }

    @Override
    public ByteVectorValues getByteVectorValues(String field) throws IOException {
        return this.flatVectorsReader.getByteVectorValues(field);
    }

    private FieldEntry getFieldEntry(String field, VectorEncoding expectedEncoding) {
        FieldEntry fieldEntry;
        FieldInfo info = this.fieldInfos.fieldInfo(field);
        if (info == null || (fieldEntry = this.fields.get(info.number)) == null) {
            throw new IllegalArgumentException("field=\"" + field + "\" not found");
        }
        if (fieldEntry.vectorEncoding != expectedEncoding) {
            throw new IllegalArgumentException("field=\"" + field + "\" is encoded as: " + String.valueOf((Object)fieldEntry.vectorEncoding) + " expected: " + String.valueOf((Object)expectedEncoding));
        }
        return fieldEntry;
    }

    @Override
    public void search(String field, float[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        FieldEntry fieldEntry = this.getFieldEntry(field, VectorEncoding.FLOAT32);
        this.search(fieldEntry, knnCollector, acceptDocs, () -> this.flatVectorsReader.getRandomVectorScorer(field, target));
    }

    @Override
    public void search(String field, byte[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        FieldEntry fieldEntry = this.getFieldEntry(field, VectorEncoding.BYTE);
        this.search(fieldEntry, knnCollector, acceptDocs, () -> this.flatVectorsReader.getRandomVectorScorer(field, target));
    }

    private void search(FieldEntry fieldEntry, KnnCollector knnCollector, Bits acceptDocs, IOSupplier<RandomVectorScorer> scorerSupplier) throws IOException {
        if (fieldEntry.size() == 0 || knnCollector.k() == 0) {
            return;
        }
        RandomVectorScorer scorer = scorerSupplier.get();
        OrdinalTranslatedKnnCollector collector = new OrdinalTranslatedKnnCollector(knnCollector, scorer::ordToDoc);
        Bits acceptedOrds = scorer.getAcceptOrds(acceptDocs);
        if (knnCollector.k() < scorer.maxOrd()) {
            HnswGraphSearcher.search(scorer, collector, this.getGraph(fieldEntry), acceptedOrds);
        } else {
            for (int i = 0; i < scorer.maxOrd(); ++i) {
                if (acceptedOrds != null && !acceptedOrds.get(i)) continue;
                if (knnCollector.earlyTerminated()) break;
                knnCollector.incVisitedCount(1);
                knnCollector.collect(scorer.ordToDoc(i), scorer.score(i));
            }
        }
    }

    @Override
    public HnswGraph getGraph(String field) throws IOException {
        FieldEntry entry;
        FieldInfo info = this.fieldInfos.fieldInfo(field);
        if (info == null || (entry = this.fields.get(info.number)) == null) {
            throw new IllegalArgumentException("field=\"" + field + "\" not found");
        }
        if (entry.vectorIndexLength > 0L) {
            return this.getGraph(entry);
        }
        return HnswGraph.EMPTY;
    }

    private HnswGraph getGraph(FieldEntry entry) throws IOException {
        return new OffHeapHnswGraph(entry, this.vectorIndex);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.flatVectorsReader, this.vectorIndex);
    }

    @Override
    public QuantizedByteVectorValues getQuantizedVectorValues(String field) throws IOException {
        if (this.flatVectorsReader instanceof QuantizedVectorsReader) {
            return ((QuantizedVectorsReader)((Object)this.flatVectorsReader)).getQuantizedVectorValues(field);
        }
        return null;
    }

    @Override
    public ScalarQuantizer getQuantizationState(String field) {
        if (this.flatVectorsReader instanceof QuantizedVectorsReader) {
            return ((QuantizedVectorsReader)((Object)this.flatVectorsReader)).getQuantizationState(field);
        }
        return null;
    }

    private record FieldEntry(VectorSimilarityFunction similarityFunction, VectorEncoding vectorEncoding, long vectorIndexOffset, long vectorIndexLength, int M, int numLevels, int dimension, int size, int[][] nodesByLevel, DirectMonotonicReader.Meta offsetsMeta, long offsetsOffset, int offsetsBlockShift, long offsetsLength) {
        static FieldEntry create(IndexInput input, VectorEncoding vectorEncoding, VectorSimilarityFunction similarityFunction) throws IOException {
            long offsetsLength;
            DirectMonotonicReader.Meta offsetsMeta;
            int offsetsBlockShift;
            long offsetsOffset;
            long vectorIndexOffset = input.readVLong();
            long vectorIndexLength = input.readVLong();
            int dimension = input.readVInt();
            int size = input.readInt();
            int M = input.readVInt();
            int numLevels = input.readVInt();
            int[][] nodesByLevel = new int[numLevels][];
            long numberOfOffsets = 0L;
            for (int level = 0; level < numLevels; ++level) {
                if (level > 0) {
                    int numNodesOnLevel = input.readVInt();
                    numberOfOffsets += (long)numNodesOnLevel;
                    nodesByLevel[level] = new int[numNodesOnLevel];
                    nodesByLevel[level][0] = input.readVInt();
                    for (int i = 1; i < numNodesOnLevel; ++i) {
                        nodesByLevel[level][i] = nodesByLevel[level][i - 1] + input.readVInt();
                    }
                    continue;
                }
                numberOfOffsets += (long)size;
            }
            if (numberOfOffsets > 0L) {
                offsetsOffset = input.readLong();
                offsetsBlockShift = input.readVInt();
                offsetsMeta = DirectMonotonicReader.loadMeta(input, numberOfOffsets, offsetsBlockShift);
                offsetsLength = input.readLong();
            } else {
                offsetsOffset = 0L;
                offsetsBlockShift = 0;
                offsetsMeta = null;
                offsetsLength = 0L;
            }
            return new FieldEntry(similarityFunction, vectorEncoding, vectorIndexOffset, vectorIndexLength, M, numLevels, dimension, size, nodesByLevel, offsetsMeta, offsetsOffset, offsetsBlockShift, offsetsLength);
        }
    }

    private static final class OffHeapHnswGraph
    extends HnswGraph {
        final IndexInput dataIn;
        final int[][] nodesByLevel;
        final int numLevels;
        final int entryNode;
        final int size;
        int arcCount;
        int arcUpTo;
        int arc;
        private final DirectMonotonicReader graphLevelNodeOffsets;
        private final long[] graphLevelNodeIndexOffsets;
        private final int[] currentNeighborsBuffer;

        OffHeapHnswGraph(FieldEntry entry, IndexInput vectorIndex) throws IOException {
            this.dataIn = vectorIndex.slice("graph-data", entry.vectorIndexOffset, entry.vectorIndexLength);
            this.nodesByLevel = entry.nodesByLevel;
            this.numLevels = entry.numLevels;
            this.entryNode = this.numLevels > 1 ? this.nodesByLevel[this.numLevels - 1][0] : 0;
            this.size = entry.size();
            RandomAccessInput addressesData = vectorIndex.randomAccessSlice(entry.offsetsOffset, entry.offsetsLength);
            this.graphLevelNodeOffsets = DirectMonotonicReader.getInstance(entry.offsetsMeta, addressesData);
            this.currentNeighborsBuffer = new int[entry.M * 2];
            this.graphLevelNodeIndexOffsets = new long[this.numLevels];
            this.graphLevelNodeIndexOffsets[0] = 0L;
            for (int i = 1; i < this.numLevels; ++i) {
                int nodeCount = this.nodesByLevel[i - 1] == null ? this.size : this.nodesByLevel[i - 1].length;
                this.graphLevelNodeIndexOffsets[i] = this.graphLevelNodeIndexOffsets[i - 1] + (long)nodeCount;
            }
        }

        @Override
        public void seek(int level, int targetOrd) throws IOException {
            int targetIndex;
            int n = targetIndex = level == 0 ? targetOrd : Arrays.binarySearch(this.nodesByLevel[level], 0, this.nodesByLevel[level].length, targetOrd);
            assert (targetIndex >= 0);
            this.dataIn.seek(this.graphLevelNodeOffsets.get((long)targetIndex + this.graphLevelNodeIndexOffsets[level]));
            this.arcCount = this.dataIn.readVInt();
            assert (this.arcCount <= this.currentNeighborsBuffer.length) : "too many neighbors: " + this.arcCount;
            if (this.arcCount > 0) {
                this.currentNeighborsBuffer[0] = this.dataIn.readVInt();
                for (int i = 1; i < this.arcCount; ++i) {
                    this.currentNeighborsBuffer[i] = this.currentNeighborsBuffer[i - 1] + this.dataIn.readVInt();
                }
            }
            this.arc = -1;
            this.arcUpTo = 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public int nextNeighbor() throws IOException {
            if (this.arcUpTo >= this.arcCount) {
                return Integer.MAX_VALUE;
            }
            this.arc = this.currentNeighborsBuffer[this.arcUpTo];
            ++this.arcUpTo;
            return this.arc;
        }

        @Override
        public int numLevels() throws IOException {
            return this.numLevels;
        }

        @Override
        public int entryNode() throws IOException {
            return this.entryNode;
        }

        @Override
        public HnswGraph.NodesIterator getNodesOnLevel(int level) {
            if (level == 0) {
                return new HnswGraph.ArrayNodesIterator(this.size());
            }
            return new HnswGraph.ArrayNodesIterator(this.nodesByLevel[level], this.nodesByLevel[level].length);
        }
    }
}

