/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.codecs.lucene99;

import guideme.internal.shaded.lucene.codecs.KnnVectorsFormat;
import guideme.internal.shaded.lucene.codecs.KnnVectorsReader;
import guideme.internal.shaded.lucene.codecs.KnnVectorsWriter;
import guideme.internal.shaded.lucene.codecs.hnsw.FlatVectorScorerUtil;
import guideme.internal.shaded.lucene.codecs.hnsw.FlatVectorsFormat;
import guideme.internal.shaded.lucene.codecs.lucene99.Lucene99FlatVectorsFormat;
import guideme.internal.shaded.lucene.codecs.lucene99.Lucene99HnswVectorsReader;
import guideme.internal.shaded.lucene.codecs.lucene99.Lucene99HnswVectorsWriter;
import guideme.internal.shaded.lucene.index.SegmentReadState;
import guideme.internal.shaded.lucene.index.SegmentWriteState;
import guideme.internal.shaded.lucene.search.TaskExecutor;
import java.io.IOException;
import java.util.concurrent.ExecutorService;

public final class Lucene99HnswVectorsFormat
extends KnnVectorsFormat {
    static final String META_CODEC_NAME = "Lucene99HnswVectorsFormatMeta";
    static final String VECTOR_INDEX_CODEC_NAME = "Lucene99HnswVectorsFormatIndex";
    static final String META_EXTENSION = "vem";
    static final String VECTOR_INDEX_EXTENSION = "vex";
    public static final int VERSION_START = 0;
    public static final int VERSION_CURRENT = 0;
    public static final int MAXIMUM_MAX_CONN = 512;
    public static final int DEFAULT_MAX_CONN = 16;
    public static final int MAXIMUM_BEAM_WIDTH = 3200;
    public static final int DEFAULT_BEAM_WIDTH = 100;
    public static final int DEFAULT_NUM_MERGE_WORKER = 1;
    static final int DIRECT_MONOTONIC_BLOCK_SHIFT = 16;
    private final int maxConn;
    private final int beamWidth;
    private static final FlatVectorsFormat flatVectorsFormat = new Lucene99FlatVectorsFormat(FlatVectorScorerUtil.getLucene99FlatVectorsScorer());
    private final int numMergeWorkers;
    private final TaskExecutor mergeExec;

    public Lucene99HnswVectorsFormat() {
        this(16, 100, 1, null);
    }

    public Lucene99HnswVectorsFormat(int maxConn, int beamWidth) {
        this(maxConn, beamWidth, 1, null);
    }

    public Lucene99HnswVectorsFormat(int maxConn, int beamWidth, int numMergeWorkers, ExecutorService mergeExec) {
        super("Lucene99HnswVectorsFormat");
        if (maxConn <= 0 || maxConn > 512) {
            throw new IllegalArgumentException("maxConn must be positive and less than or equal to 512; maxConn=" + maxConn);
        }
        if (beamWidth <= 0 || beamWidth > 3200) {
            throw new IllegalArgumentException("beamWidth must be positive and less than or equal to 3200; beamWidth=" + beamWidth);
        }
        this.maxConn = maxConn;
        this.beamWidth = beamWidth;
        if (numMergeWorkers == 1 && mergeExec != null) {
            throw new IllegalArgumentException("No executor service is needed as we'll use single thread to merge");
        }
        this.numMergeWorkers = numMergeWorkers;
        this.mergeExec = mergeExec != null ? new TaskExecutor(mergeExec) : null;
    }

    @Override
    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new Lucene99HnswVectorsWriter(state, this.maxConn, this.beamWidth, flatVectorsFormat.fieldsWriter(state), this.numMergeWorkers, this.mergeExec);
    }

    @Override
    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new Lucene99HnswVectorsReader(state, flatVectorsFormat.fieldsReader(state));
    }

    @Override
    public int getMaxDimensions(String fieldName) {
        return 1024;
    }

    public String toString() {
        return "Lucene99HnswVectorsFormat(name=Lucene99HnswVectorsFormat, maxConn=" + this.maxConn + ", beamWidth=" + this.beamWidth + ", flatVectorFormat=" + String.valueOf(flatVectorsFormat) + ")";
    }
}

