/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.synonym.word2vec;

import guideme.internal.shaded.lucene.analysis.TokenFilter;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.synonym.word2vec.TermAndBoost;
import guideme.internal.shaded.lucene.analysis.synonym.word2vec.Word2VecSynonymProvider;
import guideme.internal.shaded.lucene.analysis.tokenattributes.CharTermAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.PositionLengthAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.TypeAttribute;
import guideme.internal.shaded.lucene.util.AttributeSource;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.BytesRefBuilder;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public final class Word2VecSynonymFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posIncrementAtt = this.addAttribute(PositionIncrementAttribute.class);
    private final PositionLengthAttribute posLenAtt = this.addAttribute(PositionLengthAttribute.class);
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);
    private final Word2VecSynonymProvider synonymProvider;
    private final int maxSynonymsPerTerm;
    private final float minAcceptedSimilarity;
    private final LinkedList<TermAndBoost> synonymBuffer = new LinkedList();
    private AttributeSource.State lastState;

    public Word2VecSynonymFilter(TokenStream input, Word2VecSynonymProvider synonymProvider, int maxSynonymsPerTerm, float minAcceptedSimilarity) {
        super(input);
        if (synonymProvider == null) {
            throw new IllegalArgumentException("The SynonymProvider must be non-null");
        }
        this.synonymProvider = synonymProvider;
        this.maxSynonymsPerTerm = maxSynonymsPerTerm;
        this.minAcceptedSimilarity = minAcceptedSimilarity;
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (!this.synonymBuffer.isEmpty()) {
            TermAndBoost synonym = this.synonymBuffer.pollFirst();
            this.clearAttributes();
            this.restoreState(this.lastState);
            this.termAtt.setEmpty();
            this.termAtt.append(synonym.term().utf8ToString());
            this.typeAtt.setType("SYNONYM");
            this.posLenAtt.setPositionLength(1);
            this.posIncrementAtt.setPositionIncrement(0);
            return true;
        }
        if (this.input.incrementToken()) {
            BytesRefBuilder bytesRefBuilder = new BytesRefBuilder();
            bytesRefBuilder.copyChars(this.termAtt.buffer(), 0, this.termAtt.length());
            BytesRef term = bytesRefBuilder.get();
            List<TermAndBoost> synonyms = this.synonymProvider.getSynonyms(term, this.maxSynonymsPerTerm, this.minAcceptedSimilarity);
            if (synonyms.size() > 0) {
                this.lastState = this.captureState();
                this.synonymBuffer.addAll(synonyms);
            }
            return true;
        }
        return false;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.synonymBuffer.clear();
    }
}

