/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.ngram;

import guideme.internal.shaded.lucene.analysis.TokenFilter;
import guideme.internal.shaded.lucene.analysis.TokenFilterFactory;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.ngram.EdgeNGramTokenFilter;
import java.util.Map;

public class EdgeNGramFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "edgeNGram";
    private final int maxGramSize;
    private final int minGramSize;
    private final boolean preserveOriginal;

    public EdgeNGramFilterFactory(Map<String, String> args) {
        super(args);
        this.minGramSize = this.requireInt(args, "minGramSize");
        this.maxGramSize = this.requireInt(args, "maxGramSize");
        this.preserveOriginal = this.getBoolean(args, "preserveOriginal", false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + String.valueOf(args));
        }
    }

    public EdgeNGramFilterFactory() {
        throw EdgeNGramFilterFactory.defaultCtorException();
    }

    @Override
    public TokenFilter create(TokenStream input) {
        return new EdgeNGramTokenFilter(input, this.minGramSize, this.maxGramSize, this.preserveOriginal);
    }
}

