/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import guideme.Guide;
import guideme.Guides;
import guideme.PageAnchor;
import guideme.PageCollection;
import guideme.color.ConstantColor;
import guideme.color.SymbolicColor;
import guideme.compiler.ParsedGuidePage;
import guideme.document.DefaultStyles;
import guideme.document.LytRect;
import guideme.document.block.AlignItems;
import guideme.document.block.LytDocument;
import guideme.document.block.LytHBox;
import guideme.document.block.LytParagraph;
import guideme.document.flow.LytFlowBreak;
import guideme.document.flow.LytFlowLink;
import guideme.internal.GuideME;
import guideme.internal.GuideMEClient;
import guideme.internal.GuidebookText;
import guideme.internal.screen.DocumentScreen;
import guideme.internal.screen.GlobalInMemoryHistory;
import guideme.internal.screen.GuideIconButton;
import guideme.internal.screen.GuideNavigation;
import guideme.internal.screen.GuideScreen;
import guideme.internal.screen.GuideScreenHistory;
import guideme.internal.screen.NavigationToolbar;
import guideme.internal.search.GuideSearch;
import guideme.internal.util.Blitter;
import guideme.internal.util.NavigationUtil;
import guideme.render.GuiAssets;
import guideme.render.RenderContext;
import guideme.scene.LytItemImage;
import guideme.style.BorderStyle;
import guideme.ui.GuideUiHost;
import guideme.ui.UiPoint;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class GuideSearchScreen
extends DocumentScreen {
    public static final ResourceLocation PAGE_ID = GuideME.makeId("search");
    private static final int MIN_TITLE_HEIGHT = 16;
    private final EditBox searchField;
    private final Guide guide;
    private final NavigationToolbar toolbar;
    @Nullable
    private Screen returnToOnClose;
    private final LytDocument searchResultsDoc = new LytDocument();
    private final List<GuideSearch.SearchResult> searchResults = new ArrayList<GuideSearch.SearchResult>();

    GuideSearchScreen(Guide guide) {
        super((Component)Component.literal((String)"AE2 Guidebook Search"));
        this.guide = guide;
        this.toolbar = new NavigationToolbar(guide);
        this.toolbar.setCloseCallback(this::onClose);
        GuideMEClient.instance().getSearch().index(guide);
        this.searchField = new EditBox(Minecraft.getInstance().font, 16, 6, 0, 14, (Component)GuidebookText.Search.text());
        this.searchField.setBordered(false);
        this.searchField.setHint((Component)GuidebookText.Search.text().withStyle(ChatFormatting.DARK_GRAY).withStyle(ChatFormatting.ITALIC));
        this.searchField.setResponder(this::search);
        this.setInitialFocus((GuiEventListener)this.searchField);
    }

    public static GuideSearchScreen open(Guide guide, @Nullable String anchor) {
        GuideScreenHistory history = GlobalInMemoryHistory.get(guide);
        history.push(new PageAnchor(PAGE_ID, anchor));
        GuideSearchScreen screen = new GuideSearchScreen(guide);
        if (anchor != null) {
            screen.searchField.setValue(anchor);
        }
        return screen;
    }

    @Override
    protected LytDocument getDocument() {
        return this.searchResultsDoc;
    }

    @Override
    public void navigateTo(ResourceLocation pageId) {
    }

    @Override
    public void navigateTo(PageAnchor anchor) {
    }

    @Override
    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)this.searchField);
        this.toolbar.addToScreen(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.toolbar.update();
        this.searchField.setX(this.screenRect.x() + 16);
        this.searchField.setWidth(this.screenRect.right() - this.searchField.getX() - this.toolbar.getWidth());
        this.searchField.setCursorPosition(this.searchField.getCursorPosition());
        if (this.screenRect.isEmpty()) {
            return;
        }
        int left = this.screenRect.x();
        int documentTop = this.searchField.getY() + this.searchField.getHeight();
        int toolbarTop = (documentTop - this.toolbar.getHeight()) / 2;
        this.toolbar.move(this.screenRect.right() - this.toolbar.getWidth(), toolbarTop);
        this.setDocumentRect(new LytRect(left, documentTop, this.screenRect.right() - left, this.screenRect.height() - this.getMarginBottom()));
        this.updateDocumentLayout();
    }

    private void search(String query) {
        GlobalInMemoryHistory.get(this.guide).push(this.makeSearchAnchor());
        GuideSearch search = GuideMEClient.instance().getSearch();
        this.searchResults.clear();
        this.searchResults.addAll(search.searchGuide(query, this.guide));
        this.searchResultsDoc.clearContent();
        for (GuideSearch.SearchResult searchResult : this.searchResults) {
            ParsedGuidePage page;
            LytHBox searchResultItem = new LytHBox();
            searchResultItem.setFullWidth(true);
            searchResultItem.setGap(5);
            searchResultItem.setAlignItems(AlignItems.CENTER);
            Guide guide = Guides.getById(searchResult.guideId());
            if (guide == null || (page = guide.getParsedPage(searchResult.pageId())) == null) continue;
            ItemStack icon = NavigationUtil.createNavigationIcon(page);
            LytItemImage image = new LytItemImage();
            if (!icon.isEmpty()) {
                image.setItem(icon);
            }
            searchResultItem.append(image);
            LytParagraph summary = new LytParagraph();
            LytFlowLink documentLink = this.buildLinkToSearchResult(searchResult, guide, page);
            summary.append(documentLink);
            summary.append(new LytFlowBreak());
            summary.append(searchResult.text());
            summary.setPaddingTop(2);
            summary.setPaddingBottom(2);
            searchResultItem.append(summary);
            searchResultItem.setBorderBottom(new BorderStyle(SymbolicColor.TABLE_BORDER, 1));
            this.searchResultsDoc.append(searchResultItem);
        }
        this.updateDocumentLayout();
    }

    private LytFlowLink buildLinkToSearchResult(GuideSearch.SearchResult searchResult, Guide guide, ParsedGuidePage page) {
        LytFlowLink documentLink = new LytFlowLink();
        documentLink.appendText(searchResult.pageTitle());
        documentLink.setClickCallback(ignored -> {
            GuideUiHost guideHost;
            GuideScreenHistory history = GlobalInMemoryHistory.get(guide);
            history.push(this.makeSearchAnchor());
            Screen patt0$temp = this.returnToOnClose;
            if (patt0$temp instanceof GuideUiHost && (guideHost = (GuideUiHost)patt0$temp).getGuide() == guide) {
                this.onClose();
                guideHost.navigateTo(page.getId());
            } else {
                this.returnToOnClose = GuideScreen.openNew(guide, PageAnchor.page(page.getId()));
                this.onClose();
            }
        });
        return documentLink;
    }

    @Override
    protected void scaledRender(GuiGraphics guiGraphics, RenderContext context, int mouseX, int mouseY, float partialTick) {
        this.renderBlurredBackground(partialTick);
        context.fillIcon(this.screenRect, GuiAssets.GUIDE_BACKGROUND, SymbolicColor.GUIDE_SCREEN_BACKGROUND);
        Blitter.texture(GuideME.makeId("textures/guide/buttons.png"), 64, 64).src(GuideIconButton.Role.SEARCH.iconSrcX, GuideIconButton.Role.SEARCH.iconSrcY, 16, 16).dest(this.screenRect.x(), 2, 16, 16).colorArgb(context.resolveColor(SymbolicColor.ICON_BUTTON_NORMAL)).blit(guiGraphics);
        LytRect documentRect = this.getDocumentRect();
        context.fillRect(documentRect, new ConstantColor(-2144128205));
        if (this.searchField.getValue().isEmpty()) {
            context.renderTextCenteredIn(GuidebookText.SearchNoQuery.text().getString(), DefaultStyles.BODY_TEXT.mergeWith(DefaultStyles.BASE_STYLE), documentRect);
        } else if (this.searchResults.isEmpty()) {
            context.renderTextCenteredIn(GuidebookText.SearchNoResults.text().getString(), DefaultStyles.BODY_TEXT.mergeWith(DefaultStyles.BASE_STYLE), documentRect);
        } else {
            this.renderDocument(context);
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 200.0f);
        this.renderTitle(documentRect, context);
        super.scaledRender(guiGraphics, context, mouseX, mouseY, partialTick);
        poseStack.popPose();
        this.renderDocumentTooltip(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
    }

    private void renderTitle(LytRect documentRect, RenderContext context) {
        LytRect separatorRect = new LytRect(documentRect.x(), documentRect.y() - 1, documentRect.width(), 1);
        separatorRect = separatorRect.withWidth(this.screenRect.width());
        context.fillRect(separatorRect, SymbolicColor.HEADER1_SEPARATOR);
    }

    private PageAnchor makeSearchAnchor() {
        if (this.searchField.getValue().isBlank()) {
            return PageAnchor.page(PAGE_ID);
        }
        return new PageAnchor(PAGE_ID, this.searchField.getValue());
    }

    @Override
    protected boolean documentClicked(UiPoint documentPoint, int button) {
        if (button == 3) {
            GuideNavigation.navigateBack(this.guide);
            return true;
        }
        if (button == 4) {
            GuideNavigation.navigateForward(this.guide);
            return true;
        }
        return false;
    }

    @Override
    public void onClose() {
        if (this.minecraft != null && this.minecraft.screen == this && this.returnToOnClose != null) {
            this.minecraft.setScreen(this.returnToOnClose);
            this.returnToOnClose = null;
            return;
        }
        super.onClose();
    }

    public void setReturnToOnClose(@Nullable Screen screen) {
        this.returnToOnClose = screen;
    }

    @Nullable
    public Screen getReturnToOnClose() {
        return this.returnToOnClose;
    }

    @Override
    public PageCollection getGuide() {
        return this.guide;
    }

    @Override
    public void reloadPage() {
    }
}

