/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import guideme.Guide;
import guideme.GuidePage;
import guideme.PageAnchor;
import guideme.PageCollection;
import guideme.color.ConstantColor;
import guideme.color.SymbolicColor;
import guideme.compiler.AnchorIndexer;
import guideme.compiler.PageCompiler;
import guideme.compiler.ParsedGuidePage;
import guideme.document.DefaultStyles;
import guideme.document.LytRect;
import guideme.document.block.LytBlock;
import guideme.document.block.LytDocument;
import guideme.document.block.LytHeading;
import guideme.document.block.LytParagraph;
import guideme.document.flow.LytFlowAnchor;
import guideme.document.flow.LytFlowContent;
import guideme.document.flow.LytFlowSpan;
import guideme.internal.GuidebookText;
import guideme.internal.screen.DocumentScreen;
import guideme.internal.screen.GlobalInMemoryHistory;
import guideme.internal.screen.GuideNavBar;
import guideme.internal.screen.GuideNavigation;
import guideme.internal.screen.GuideScreenHistory;
import guideme.internal.screen.NavigationToolbar;
import guideme.layout.LayoutContext;
import guideme.layout.MinecraftFontMetrics;
import guideme.render.GuiAssets;
import guideme.render.GuidePageTexture;
import guideme.render.RenderContext;
import guideme.style.TextAlignment;
import guideme.style.TextStyle;
import guideme.ui.GuideUiHost;
import guideme.ui.UiPoint;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModInfo;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuideScreen
extends DocumentScreen
implements GuideUiHost {
    private static final Logger LOG = LoggerFactory.getLogger(GuideScreen.class);
    private final Guide guide;
    private GuidePage currentPage;
    private final LytParagraph pageTitle;
    private final NavigationToolbar toolbar;
    @Nullable
    private Screen returnToOnClose;
    @Nullable
    private String pendingScrollToAnchor;
    private final GuideNavBar navbar;

    private GuideScreen(Guide guide, PageAnchor anchor) {
        super((Component)Component.literal((String)"GuideME Guidebook"));
        this.guide = guide;
        this.pageTitle = new LytParagraph();
        this.pageTitle.setStyle(DefaultStyles.HEADING1);
        this.toolbar = new NavigationToolbar(guide);
        this.toolbar.setCloseCallback(this::onClose);
        this.toolbar.setCanSearch(true);
        this.navbar = new GuideNavBar(this);
        this.loadPageAndScrollTo(anchor);
    }

    public static GuideScreen openNew(Guide guide, PageAnchor anchor) {
        return GuideScreen.openNew(guide, anchor, GlobalInMemoryHistory.get(guide));
    }

    public static GuideScreen openNew(Guide guide, PageAnchor anchor, GuideScreenHistory history) {
        history.push(anchor);
        return new GuideScreen(guide, anchor);
    }

    @Override
    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)this.navbar);
        this.toolbar.addToScreen(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.updateScreenLayout();
    }

    private void updateScreenLayout() {
        if (this.screenRect.isEmpty()) {
            return;
        }
        this.navbar.setPinned(this.hasSpaceForSidebar());
        this.navbar.setX(this.screenRect.x());
        int left = this.screenRect.x();
        if (!this.navbar.isPinned() && left < 15) {
            left = 15;
        }
        int availableWidth = this.screenRect.right() - left - this.toolbar.getWidth() - 5;
        this.updateTitleLayout(left, availableWidth);
        int marginTop = this.pageTitle.getBounds().bottom() + 4;
        int toolbarTop = (marginTop - this.toolbar.getHeight()) / 2;
        this.toolbar.move(this.screenRect.right() - this.toolbar.getWidth(), toolbarTop);
        if (this.navbar.isPinned()) {
            left = this.screenRect.x() + this.navbar.getWidth();
        }
        this.setDocumentRect(new LytRect(left, this.screenRect.y() + marginTop, this.screenRect.right() - left, this.screenRect.height() - this.getMarginBottom() - marginTop));
        if (this.navbar.isPinned()) {
            this.navbar.setY(this.getDocumentRect().y());
            this.navbar.setHeight(this.getDocumentRect().height());
        } else {
            this.navbar.setY(this.screenRect.y());
            this.navbar.setHeight(this.screenRect.height());
        }
        this.updateDocumentLayout();
    }

    @Override
    public void tick() {
        super.tick();
        this.toolbar.update();
        this.processPendingScrollTo();
    }

    @Override
    protected boolean documentClicked(UiPoint documentPoint, int button) {
        if (button == 3) {
            GuideNavigation.navigateBack(this.guide);
            return true;
        }
        if (button == 4) {
            GuideNavigation.navigateForward(this.guide);
            return true;
        }
        return false;
    }

    private void processPendingScrollTo() {
        LytFlowAnchor flowAnchor;
        if (this.pendingScrollToAnchor == null) {
            return;
        }
        String anchor = this.pendingScrollToAnchor;
        this.pendingScrollToAnchor = null;
        AnchorIndexer indexer = new AnchorIndexer(this.currentPage.document());
        AnchorIndexer.AnchorTarget targetAnchor = indexer.get(anchor);
        if (targetAnchor == null) {
            LOG.warn("Failed to find anchor {} in page {}", (Object)anchor, (Object)this.currentPage);
            return;
        }
        LytFlowContent lytFlowContent = targetAnchor.flowContent();
        if (lytFlowContent instanceof LytFlowAnchor && (flowAnchor = (LytFlowAnchor)lytFlowContent).getLayoutY().isPresent()) {
            this.setDocumentScrollY(flowAnchor.getLayoutY().getAsInt());
        } else {
            LytRect bounds = targetAnchor.blockNode().getBounds();
            this.setDocumentScrollY(bounds.y());
        }
    }

    @Override
    public void scaledRender(GuiGraphics guiGraphics, RenderContext context, int mouseX, int mouseY, float partialTick) {
        this.renderBlurredBackground(partialTick);
        context.fillIcon(this.screenRect, GuiAssets.GUIDE_BACKGROUND, SymbolicColor.GUIDE_SCREEN_BACKGROUND);
        LytRect documentRect = this.getDocumentRect();
        context.fillRect(documentRect, new ConstantColor(0x40333333));
        this.renderDocument(context);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 200.0f);
        this.renderTitle(documentRect, context);
        if (this.hasFooter()) {
            this.renderFooter(documentRect, context);
        }
        super.scaledRender(guiGraphics, context, mouseX, mouseY, partialTick);
        poseStack.popPose();
        this.renderDocumentTooltip(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderFooter(LytRect documentRect, RenderContext context) {
        String externalSource = this.getExternalSourceName();
        if (externalSource != null) {
            LytParagraph paragraph = new LytParagraph();
            paragraph.appendText(GuidebookText.ContentFrom.text().getString() + " ");
            LytFlowSpan sourceSpan = new LytFlowSpan();
            sourceSpan.appendText(externalSource);
            sourceSpan.setStyle(TextStyle.builder().italic(true).build());
            paragraph.append(sourceSpan);
            paragraph.setStyle(TextStyle.builder().alignment(TextAlignment.RIGHT).build());
            LayoutContext layoutContext = new LayoutContext(new MinecraftFontMetrics());
            paragraph.layout(layoutContext, documentRect.x(), documentRect.bottom(), documentRect.width());
            MultiBufferSource.BufferSource buffers = context.beginBatch();
            paragraph.renderBatch(context, (MultiBufferSource)buffers);
            context.endBatch(buffers);
        }
    }

    @Override
    protected boolean hasFooter() {
        return this.getExternalSourceName() != null;
    }

    @Nullable
    private String getExternalSourceName() {
        String sourcePackId = this.currentPage.sourcePack();
        if (sourcePackId.startsWith("mod:") || sourcePackId.startsWith("mod/")) {
            String modId = sourcePackId.substring("mod:".length());
            if (this.guide.getDefaultNamespace().equals(modId)) {
                return null;
            }
            return ModList.get().getModContainerById(modId).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(null);
        }
        if (this.guide.getDefaultNamespace().equals(sourcePackId)) {
            return null;
        }
        Pack pack = Minecraft.getInstance().getResourcePackRepository().getPack(sourcePackId);
        if (pack != null) {
            return pack.getDescription().getString();
        }
        return null;
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
    }

    private void renderTitle(LytRect documentRect, RenderContext context) {
        MultiBufferSource.BufferSource buffers = context.beginBatch();
        this.pageTitle.renderBatch(context, (MultiBufferSource)buffers);
        context.endBatch(buffers);
        LytRect separatorRect = new LytRect(this.screenRect.x(), documentRect.y() - 1, this.screenRect.width(), 1);
        separatorRect = separatorRect.withWidth(this.screenRect.width());
        context.fillRect(separatorRect, SymbolicColor.HEADER1_SEPARATOR);
    }

    @Override
    public void navigateTo(ResourceLocation pageId) {
        this.navigateTo(PageAnchor.page(pageId));
    }

    @Override
    public void navigateTo(PageAnchor anchor) {
        GuideNavigation.navigateTo(this.guide, anchor);
    }

    void loadPageAndScrollTo(PageAnchor anchor) {
        this.loadPage(anchor.pageId());
        this.setDocumentScrollY(0);
        this.updateDocumentLayout();
        this.pendingScrollToAnchor = anchor.anchor();
    }

    @Override
    public void reloadPage() {
        this.loadPage(this.currentPage.id());
        this.updateDocumentLayout();
    }

    private void loadPage(ResourceLocation pageId) {
        GuidePageTexture.releaseUsedTextures();
        ParsedGuidePage page = this.guide.getParsedPage(pageId);
        if (page == null) {
            page = this.buildNotFoundPage(pageId);
        }
        this.currentPage = PageCompiler.compile(this.guide, this.guide.getExtensions(), page);
        this.pageTitle.clearContent();
        for (LytFlowContent flowContent : this.extractPageTitle(this.currentPage)) {
            this.pageTitle.append(flowContent);
        }
        this.updateScreenLayout();
    }

    private Iterable<LytFlowContent> extractPageTitle(GuidePage page) {
        for (LytBlock block : page.document().getBlocks()) {
            if (!(block instanceof LytHeading)) continue;
            LytHeading heading = (LytHeading)block;
            if (heading.getDepth() != 1) break;
            page.document().removeChild(heading);
            return heading.getContent();
        }
        return List.of();
    }

    private ParsedGuidePage buildNotFoundPage(ResourceLocation pageId) {
        String pageSource = "# Page not Found\n\nPage \"" + String.valueOf(pageId) + "\" could not be found.";
        return PageCompiler.parse(pageId.getNamespace(), "en_us", pageId, pageSource);
    }

    public void removed() {
        super.removed();
        GuidePageTexture.releaseUsedTextures();
    }

    public void setReturnToOnClose(@Nullable Screen screen) {
        this.returnToOnClose = screen;
    }

    @Nullable
    public Screen getReturnToOnClose() {
        return this.returnToOnClose;
    }

    @Override
    protected LytDocument getDocument() {
        return this.currentPage.document();
    }

    private void updateTitleLayout(int left, int availableWidth) {
        LayoutContext context = new LayoutContext(new MinecraftFontMetrics());
        if (availableWidth < 0) {
            availableWidth = 0;
        }
        int minTitleHeight = 20;
        this.pageTitle.layout(context, 0, 0, availableWidth);
        int titleY = Math.max(4, minTitleHeight - this.pageTitle.getBounds().height()) / 2;
        this.pageTitle.layout(context, left + 5, titleY, availableWidth);
    }

    public void scrollToAnchor(@Nullable String anchor) {
        this.pendingScrollToAnchor = anchor;
        if (anchor == null) {
            this.setDocumentScrollY(0);
        }
    }

    @Override
    public PageCollection getGuide() {
        return this.guide;
    }

    public ResourceLocation getCurrentPageId() {
        return this.currentPage.id();
    }

    @Override
    public void onClose() {
        if (this.minecraft != null && this.minecraft.screen == this && this.returnToOnClose != null) {
            this.minecraft.setScreen(this.returnToOnClose);
            this.returnToOnClose = null;
            return;
        }
        super.onClose();
    }

    private boolean hasSpaceForSidebar() {
        return this.width >= super.getMaxWidth();
    }
}

