/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.screen;

import guideme.color.SymbolicColor;
import guideme.internal.GuideME;
import guideme.internal.GuideMEClient;
import guideme.internal.GuidebookText;
import guideme.internal.util.Blitter;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;

public class GuideIconButton
extends Button {
    public static final int WIDTH = 16;
    public static final int HEIGHT = 16;
    private Role role;

    public GuideIconButton(int x, int y, Role role, Runnable callback) {
        this(x, y, role, (GuideIconButton btn) -> callback.run());
    }

    public GuideIconButton(int x, int y, Role role, Consumer<GuideIconButton> callback) {
        super(x, y, 16, 16, role.actionText, btn -> callback.accept((GuideIconButton)btn), Supplier::get);
        this.role = role;
        this.setTooltip(Tooltip.create((Component)this.getMessage()));
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
        this.setMessage(role.actionText);
        this.setTooltip(Tooltip.create((Component)this.getMessage()));
    }

    public void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        SymbolicColor color = SymbolicColor.ICON_BUTTON_NORMAL;
        if (!this.isActive()) {
            color = SymbolicColor.ICON_BUTTON_DISABLED;
        } else if (this.isHovered()) {
            color = SymbolicColor.ICON_BUTTON_HOVER;
        }
        int resolved = color.resolve(GuideMEClient.currentLightDarkMode());
        Blitter.texture(GuideME.makeId("textures/guide/buttons.png"), 64, 64).src(this.role.iconSrcX, this.role.iconSrcY, 16, 16).dest(this.getX(), this.getY(), 16, 16).colorArgb(resolved).blit(guiGraphics);
    }

    public static enum Role {
        BACK((Component)GuidebookText.HistoryGoBack.text(), 0, 0),
        FORWARD((Component)GuidebookText.HistoryGoForward.text(), 16, 0),
        CLOSE((Component)GuidebookText.Close.text(), 32, 0),
        SEARCH((Component)GuidebookText.Search.text(), 48, 0),
        HIDE_ANNOTATIONS((Component)GuidebookText.HideAnnotations.text(), 0, 16),
        SHOW_ANNOTATIONS((Component)GuidebookText.ShowAnnotations.text(), 16, 16),
        ZOOM_OUT((Component)GuidebookText.ZoomOut.text(), 32, 16),
        ZOOM_IN((Component)GuidebookText.ZoomIn.text(), 48, 16),
        RESET_VIEW((Component)GuidebookText.ResetView.text(), 0, 32),
        OPEN_FULL_WIDTH_VIEW((Component)GuidebookText.FullWidthView.text(), 16, 32),
        CLOSE_FULL_WIDTH_VIEW((Component)GuidebookText.CloseFullWidthView.text(), 32, 32);

        final Component actionText;
        final int iconSrcX;
        final int iconSrcY;

        private Role(Component actionText, int iconSrcX, int iconSrcY) {
            this.actionText = actionText;
            this.iconSrcX = iconSrcX;
            this.iconSrcY = iconSrcY;
        }
    }
}

