/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.ae2netanalyser.client.render;

import com.glodblock.github.ae2netanalyser.client.render.NetworkDataHandler;
import com.glodblock.github.ae2netanalyser.common.AEASingletons;
import com.glodblock.github.ae2netanalyser.common.items.ItemNetworkAnalyzer;
import com.glodblock.github.ae2netanalyser.common.me.AnalyserMode;
import com.glodblock.github.ae2netanalyser.common.me.NetworkData;
import com.glodblock.github.ae2netanalyser.common.me.netdata.LinkFlag;
import com.glodblock.github.ae2netanalyser.util.ClientUtil;
import com.glodblock.github.ae2netanalyser.util.Util;
import com.glodblock.github.glodium.client.render.ColorData;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class NetworkRender
extends RenderType {
    public static final NetworkRender INSTANCE = new NetworkRender();
    private static final Set<AnalyserMode> renderNodeModes = EnumSet.of(AnalyserMode.NODES, AnalyserMode.FULL, AnalyserMode.NONUM);
    private static final Set<AnalyserMode> renderLinkModes = EnumSet.of(AnalyserMode.CHANNELS, AnalyserMode.FULL, AnalyserMode.NONUM, AnalyserMode.P2P);
    private static ItemStack currentAnalyser;
    private static final ColorData WHITE;
    private static VertexBuffer VBO;
    private final RenderStateShard.TransparencyStateShard STO = new RenderStateShard.TransparencyStateShard("sto", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    private final RenderType CUBE_RENDER = NetworkRender.create((String)"aea_cube", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTransparencyState(this.STO).setDepthTestState(NO_DEPTH_TEST).setCullState(NO_CULL).setShaderState(POSITION_COLOR_SHADER).setLightmapState(NO_LIGHTMAP).setWriteMaskState(COLOR_DEPTH_WRITE).setTextureState(NO_TEXTURE).createCompositeState(true));

    public static void hook(RenderLevelStageEvent event) {
        LocalPlayer player;
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES && (player = Minecraft.getInstance().player) != null && player.getMainHandItem().getItem() == AEASingletons.ANALYSER) {
            GlobalPos pos;
            if (currentAnalyser != player.getMainHandItem()) {
                currentAnalyser = player.getMainHandItem();
                NetworkDataHandler.updateConfig((ItemNetworkAnalyzer.AnalyserConfig)currentAnalyser.getOrDefault(AEASingletons.ANALYZER_CONFIG, (Object)ItemNetworkAnalyzer.defaultConfig));
            }
            if ((pos = (GlobalPos)currentAnalyser.get(AEASingletons.GLOBAL_POS)) != null && pos.dimension().equals(player.level().dimension())) {
                INSTANCE.tick(event.getPoseStack(), Minecraft.getInstance().renderBuffers().bufferSource(), event.getProjectionMatrix(), event.getCamera());
            }
        }
    }

    public void renderNodes(@NotNull NetworkData data, PoseStack stack, BufferBuilder buf) {
        for (NetworkData.ANode node : data.nodes) {
            ColorData color = NetworkDataHandler.getColorByConfig(node.state().get());
            this.drawCube(NetworkDataHandler.getNodeSize(), color, node.pos(), stack, buf);
        }
    }

    public void renderLinks(@NotNull NetworkData data, PoseStack stack, BufferBuilder buf, boolean p2pOnly) {
        for (NetworkData.ALink link : data.links) {
            LinkFlag flag = link.state().get();
            if (p2pOnly && flag != LinkFlag.COMPRESSED) continue;
            ColorData color = NetworkDataHandler.getColorByConfig(flag);
            this.drawLink(flag == LinkFlag.DENSE, color, link.a().pos(), link.b().pos(), stack, buf);
        }
    }

    public void drawInWorldText(String text, ColorData color, Vec3 pos, Vec3 offset, Camera camera, PoseStack stack, MultiBufferSource multiBuf) {
        float scale = 0.027f;
        Font fontRender = Minecraft.getInstance().font;
        Vec3 c = pos.add(offset);
        float stringMiddle = (float)fontRender.width(text) / 2.0f;
        stack.pushPose();
        stack.translate(c.x, c.y, c.z);
        stack.mulPose(camera.rotation());
        stack.scale(scale, -scale, scale);
        Matrix4f mat = stack.last().pose();
        fontRender.drawInBatch(text, -stringMiddle, 0.0f, color.toARGB(), false, mat, multiBuf, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        stack.popPose();
    }

    public void drawCube(float size, ColorData color, BlockPos pos, PoseStack stack, BufferBuilder buf) {
        float half = size / 2.0f;
        Vec3 c = pos.getCenter();
        AABB box = new AABB(c.x - (double)half, c.y - (double)half, c.z - (double)half, c.x + (double)half, c.y + (double)half, c.z + (double)half);
        Vec3 topRight = new Vec3(box.maxX, box.maxY, box.maxZ);
        Vec3 bottomRight = new Vec3(box.maxX, box.minY, box.maxZ);
        Vec3 bottomLeft = new Vec3(box.minX, box.minY, box.maxZ);
        Vec3 topLeft = new Vec3(box.minX, box.maxY, box.maxZ);
        Vec3 topRight2 = new Vec3(box.maxX, box.maxY, box.minZ);
        Vec3 bottomRight2 = new Vec3(box.maxX, box.minY, box.minZ);
        Vec3 bottomLeft2 = new Vec3(box.minX, box.minY, box.minZ);
        Vec3 topLeft2 = new Vec3(box.minX, box.maxY, box.minZ);
        this.drawSide(topRight, topLeft, bottomRight, bottomLeft, color, (VertexConsumer)buf, stack);
        this.drawSide(topRight2, topRight, bottomRight2, bottomRight, color, (VertexConsumer)buf, stack);
        this.drawSide(topLeft2, topRight2, bottomLeft2, bottomRight2, color, (VertexConsumer)buf, stack);
        this.drawSide(topLeft, topLeft2, bottomLeft, bottomLeft2, color, (VertexConsumer)buf, stack);
        this.drawSide(topLeft2, topRight2, topLeft, topRight, color, (VertexConsumer)buf, stack);
        this.drawSide(bottomLeft2, bottomRight2, bottomLeft, bottomRight, color, (VertexConsumer)buf, stack);
    }

    public void drawLink(boolean isDense, ColorData color, BlockPos from, BlockPos to, PoseStack stack, BufferBuilder buf) {
        Vec3 a = from.getCenter();
        Vec3 b = to.getCenter();
        double wide = isDense ? 0.1 : 0.025;
        Vec3 law = ClientUtil.getLawVec(a, b).scale(wide);
        Vec3 law2 = ClientUtil.getLawVec2(a, b).scale(wide);
        Vec3 topRight = a.add(law2);
        Vec3 bottomRight = a.subtract(law);
        Vec3 bottomLeft = a.subtract(law2);
        Vec3 topLeft = a.add(law);
        Vec3 topRight2 = b.add(law2);
        Vec3 bottomRight2 = b.subtract(law);
        Vec3 bottomLeft2 = b.subtract(law2);
        Vec3 topLeft2 = b.add(law);
        this.drawSide(topRight, topLeft, bottomRight, bottomLeft, color, (VertexConsumer)buf, stack);
        this.drawSide(topRight2, topRight, bottomRight2, bottomRight, color, (VertexConsumer)buf, stack);
        this.drawSide(topLeft2, topRight2, bottomLeft2, bottomRight2, color, (VertexConsumer)buf, stack);
        this.drawSide(topLeft, topLeft2, bottomLeft, bottomLeft2, color, (VertexConsumer)buf, stack);
        this.drawSide(topLeft2, topRight2, topLeft, topRight, color, (VertexConsumer)buf, stack);
        this.drawSide(bottomLeft2, bottomRight2, bottomLeft, bottomRight, color, (VertexConsumer)buf, stack);
    }

    private void drawSide(Vec3 tr, Vec3 tl, Vec3 br, Vec3 bl, ColorData color, VertexConsumer buf, PoseStack pose) {
        Matrix4f mat = pose.last().pose();
        buf.addVertex(mat, (float)tr.x, (float)tr.y, (float)tr.z).setColor(color.getRf(), color.getGf(), color.getBf(), color.getAf());
        buf.addVertex(mat, (float)br.x, (float)br.y, (float)br.z).setColor(color.getRf(), color.getGf(), color.getBf(), color.getAf());
        buf.addVertex(mat, (float)bl.x, (float)bl.y, (float)bl.z).setColor(color.getRf(), color.getGf(), color.getBf(), color.getAf());
        buf.addVertex(mat, (float)tl.x, (float)tl.y, (float)tl.z).setColor(color.getRf(), color.getGf(), color.getBf(), color.getAf());
    }

    public void createVBO(AnalyserMode mode, NetworkData data) {
        MeshData rendered;
        if (VBO != null) {
            VBO.close();
        }
        BufferBuilder buf = new BufferBuilder(new ByteBufferBuilder(this.CUBE_RENDER.bufferSize() * 8), this.CUBE_RENDER.mode(), this.CUBE_RENDER.format());
        PoseStack stack = new PoseStack();
        if (renderNodeModes.contains((Object)mode)) {
            this.renderNodes(data, stack, buf);
        }
        if (renderLinkModes.contains((Object)mode)) {
            this.renderLinks(data, stack, buf, mode == AnalyserMode.P2P);
        }
        if ((rendered = buf.build()) != null) {
            VBO = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
            VBO.bind();
            VBO.upload(rendered);
            VertexBuffer.unbind();
        }
    }

    public void tick(PoseStack stack, MultiBufferSource.BufferSource multiBuf, Matrix4f pro, Camera camera) {
        if (NetworkDataHandler.pullData() == null || GameRenderer.getPositionColorShader() == null) {
            return;
        }
        if (camera.isInitialized()) {
            Vec3 offset = camera.getPosition().reverse();
            AnalyserMode mode = NetworkDataHandler.getMode();
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            if (NetworkDataHandler.update()) {
                this.createVBO(mode, NetworkDataHandler.pullData());
            }
            if (VBO != null) {
                RenderSystem.setShader(GameRenderer::getPositionColorShader);
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.disableCull();
                stack.pushPose();
                Quaternionf rotation = new Quaternionf((Quaternionfc)camera.rotation());
                rotation.invert();
                stack.mulPose(rotation);
                stack.translate(offset.x, offset.y, offset.z);
                VBO.bind();
                VBO.drawWithShader(stack.last().pose(), pro, GameRenderer.getPositionColorShader());
                VertexBuffer.unbind();
                stack.popPose();
                RenderSystem.enableCull();
            }
            RenderSystem.disableBlend();
            if (mode == AnalyserMode.FULL && !Util.isInfChannel()) {
                for (NetworkData.ALink link : NetworkDataHandler.pullData().links) {
                    if (link.channel() <= 0) continue;
                    this.drawInWorldText(String.valueOf(link.channel()), WHITE, ClientUtil.getCenter(link.a().pos(), link.b().pos()), offset, camera, stack, (MultiBufferSource)multiBuf);
                }
            }
            multiBuf.endBatch();
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        }
    }

    public NetworkRender() {
        super("", DefaultVertexFormat.POSITION_COLOR_NORMAL, VertexFormat.Mode.LINES, 0, false, false, () -> {}, () -> {});
    }

    static {
        WHITE = new ColorData(1.0f, 1.0f, 1.0f);
        VBO = null;
    }
}

