/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.util;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.parts.AEBasePart;
import com.glodblock.github.appflux.common.AFSingletons;
import com.glodblock.github.appflux.util.helpers.Constants;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.ItemCapability;
import org.jetbrains.annotations.Nullable;

public class AFUtil {
    public static int clampLong(long value) {
        return (int)Math.min(value, Integer.MAX_VALUE);
    }

    @Nullable
    public static <T> T findCapability(ItemStack stack, ItemCapability<T, Void> capability) {
        if (!stack.isEmpty()) {
            return (T)stack.getCapability(capability);
        }
        return null;
    }

    public static boolean shouldTryCast(BlockEntity tile, Direction side) {
        IPartHost host;
        IPart iPart;
        if (tile instanceof IUpgradeableObject) {
            IUpgradeableObject upgradeable = (IUpgradeableObject)tile;
            return upgradeable.isUpgradedWith((ItemLike)AFSingletons.INDUCTION_CARD);
        }
        if (tile instanceof IPartHost && (iPart = (host = (IPartHost)tile).getPart(side)) instanceof IUpgradeableObject) {
            IUpgradeableObject upgradeable = (IUpgradeableObject)iPart;
            return upgradeable.isUpgradedWith((ItemLike)AFSingletons.INDUCTION_CARD);
        }
        return true;
    }

    public static Set<Direction> getSides(Object host) {
        if (host instanceof BlockEntity) {
            return Constants.ALL_DIRECTIONS;
        }
        if (host instanceof AEBasePart) {
            AEBasePart part = (AEBasePart)host;
            if (part.getSide() == null) {
                return Constants.NO_DIRECTIONS;
            }
            return Set.of(part.getSide());
        }
        return Constants.NO_DIRECTIONS;
    }
}

