/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.sgearmetalworks.util;

import cy.jdkdigital.sgearmetalworks.recipe.SilentGearCastingRecipe;
import cy.jdkdigital.sgearmetalworks.registry.SGearMetalworksRegistrator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class RecipeHelper {
    static Map<String, RecipeHolder<SilentGearCastingRecipe>> gearCastingRecipeCache = new HashMap<String, RecipeHolder<SilentGearCastingRecipe>>();

    public static RecipeHolder<SilentGearCastingRecipe> getSilentGearCastingRecipe(Level level, ItemStack cast, FluidStack fluid) {
        String cacheKey = cy.jdkdigital.productivemetalworks.util.RecipeHelper.itemCacheKey((ItemStack)cast) + cy.jdkdigital.productivemetalworks.util.RecipeHelper.fluidCacheKey((FluidStack)fluid);
        if (!gearCastingRecipeCache.containsKey(cacheKey)) {
            for (RecipeHolder recipeHolder : level.getRecipeManager().getAllRecipesFor((RecipeType)SGearMetalworksRegistrator.SG_GEAR_CASTING_TYPE.get())) {
                if (!((SilentGearCastingRecipe)recipeHolder.value()).matches(cast, fluid, level)) continue;
                gearCastingRecipeCache.put(cacheKey, (RecipeHolder<SilentGearCastingRecipe>)recipeHolder);
            }
        }
        return gearCastingRecipeCache.getOrDefault(cacheKey, null);
    }
}

