/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items.interfaces;

import com.direwolf20.justdirethings.common.items.interfaces.AbilityMethods;
import com.direwolf20.justdirethings.common.items.interfaces.AbilityParams;
import com.direwolf20.justdirethings.setup.Registration;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public enum Ability {
    MOBSCANNER(SettingType.TOGGLE, 10, 500, UseType.USE, BindingType.LEFT_AND_CUSTOM, AbilityMethods::scanForMobScanner, CustomSettingType.NONE, (Holder<Item>)Registration.UPGRADE_MOBSCANNER),
    OREMINER(SettingType.TOGGLE, 1, 50, UseType.PASSIVE, BindingType.CUSTOM_ONLY, (Holder<Item>)Registration.UPGRADE_OREMINER),
    ORESCANNER(SettingType.TOGGLE, 10, 500, UseType.USE, BindingType.LEFT_AND_CUSTOM, AbilityMethods::scanForOreScanner, CustomSettingType.NONE, (Holder<Item>)Registration.UPGRADE_ORESCANNER),
    LAWNMOWER(SettingType.TOGGLE, 1, 50, UseType.USE, BindingType.LEFT_AND_CUSTOM, AbilityMethods::lawnmower, CustomSettingType.NONE, (Holder<Item>)Registration.UPGRADE_LAWNMOWER),
    SKYSWEEPER(SettingType.TOGGLE, 1, 50, UseType.PASSIVE, BindingType.CUSTOM_ONLY, (Holder<Item>)Registration.UPGRADE_SKYSWEEPER),
    TREEFELLER(SettingType.TOGGLE, 1, 50, UseType.PASSIVE, BindingType.CUSTOM_ONLY, (Holder<Item>)Registration.UPGRADE_TREEFELLER),
    LEAFBREAKER(SettingType.TOGGLE, 1, 50, UseType.USE_ON, BindingType.LEFT_AND_CUSTOM, AbilityMethods::leafbreaker, CustomSettingType.NONE, (Holder<Item>)Registration.UPGRADE_LEAFBREAKER),
    RUNSPEED(SettingType.SLIDER, 1, 5, UseType.PASSIVE_TICK, BindingType.CUSTOM_ONLY, AbilityMethods::runSpeed, CustomSettingType.NONE, (Holder<Item>)Registration.UPGRADE_RUNSPEED),
    WALKSPEED(SettingType.SLIDER, 1, 5, UseType.PASSIVE_TICK, BindingType.CUSTOM_ONLY, AbilityMethods::walkSpeed, CustomSettingType.NONE, (Holder<Item>)Registration.UPGRADE_WALKSPEED),
    STEPHEIGHT(SettingType.TOGGLE, 1, 5, UseType.PASSIVE, BindingType.CUSTOM_ONLY, (Holder<Item>)Registration.UPGRADE_STEPHEIGHT),
    JUMPBOOST(SettingType.SLIDER, 1, 5, UseType.PASSIVE, BindingType.CUSTOM_ONLY, AbilityMethods::jumpBoost, CustomSettingType.NONE, (Holder<Item>)Registration.UPGRADE_JUMPBOOST),
    MINDFOG(SettingType.TOGGLE, 1, 50, UseType.PASSIVE, BindingType.CUSTOM_ONLY, (Holder<Item>)Registration.UPGRADE_MINDFOG),
    INVULNERABILITY(SettingType.SLIDER, 25, 5000, UseType.USE_COOLDOWN, BindingType.CUSTOM_ONLY, AbilityMethods::invulnerability, CustomSettingType.NONE, ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/overlay/invulnerability.png"), (Holder<Item>)Registration.UPGRADE_INVULNERABILITY),
    POTIONARROW(SettingType.TOGGLE, 1, 50, UseType.PASSIVE, BindingType.CUSTOM_ONLY, (Holder<Item>)Registration.UPGRADE_POTIONARROW),
    SMELTER(SettingType.TOGGLE, 1, 50, UseType.PASSIVE, BindingType.CUSTOM_ONLY, (Holder<Item>)Registration.UPGRADE_SMELTER),
    SMOKER(SettingType.TOGGLE, 1, 50, UseType.PASSIVE, BindingType.CUSTOM_ONLY, (Holder<Item>)Registration.UPGRADE_SMOKER),
    HAMMER(SettingType.CYCLE, 1, 50, UseType.PASSIVE, BindingType.CUSTOM_ONLY, (Holder<Item>)Registration.UPGRADE_HAMMER),
    LAVAREPAIR(SettingType.TOGGLE, 0, 0, UseType.PASSIVE, BindingType.CUSTOM_ONLY),
    CAUTERIZEWOUNDS(SettingType.TOGGLE, 30, 1500, UseType.USE_COOLDOWN, BindingType.LEFT_AND_CUSTOM, AbilityMethods::cauterizeWounds, CustomSettingType.NONE, ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/overlay/cauterizewounds.png"), (Holder<Item>)Registration.UPGRADE_CAUTERIZEWOUNDS),
    AIRBURST(SettingType.SLIDER, 1, 250, UseType.USE, BindingType.LEFT_AND_CUSTOM, AbilityMethods::airBurst, CustomSettingType.NONE),
    SWIMSPEED(SettingType.SLIDER, 1, 5, UseType.PASSIVE_TICK, BindingType.CUSTOM_ONLY, AbilityMethods::swimSpeed, CustomSettingType.NONE, (Holder<Item>)Registration.UPGRADE_SWIMSPEED),
    GROUNDSTOMP(SettingType.SLIDER, 25, 5000, UseType.USE_COOLDOWN, BindingType.CUSTOM_ONLY, AbilityMethods::groundstomp, CustomSettingType.NONE, ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/overlay/groundstomp.png"), (Holder<Item>)Registration.UPGRADE_GROUNDSTOMP),
    EXTINGUISH(SettingType.SLIDER, 25, 5000, UseType.PASSIVE_TICK_COOLDOWN, BindingType.CUSTOM_ONLY, AbilityMethods::extinguish, CustomSettingType.NONE, ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/overlay/extinguish.png"), (Holder<Item>)Registration.UPGRADE_EXTINGUISH),
    STUPEFY(SettingType.SLIDER, 25, 5000, UseType.USE_COOLDOWN, BindingType.CUSTOM_ONLY, AbilityMethods::stupefy, CustomSettingType.NONE, ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/overlay/stupefy.png"), (Holder<Item>)Registration.UPGRADE_STUPEFY),
    SPLASH(SettingType.TOGGLE, 20, 250, UseType.PASSIVE, BindingType.CUSTOM_ONLY, (Holder<Item>)Registration.UPGRADE_SPLASH),
    POLYMORPH_RANDOM(SettingType.TOGGLE, 10, 1000, UseType.USE, BindingType.LEFT_AND_CUSTOM, AbilityMethods::polymorphRandom, CustomSettingType.NONE, ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/overlay/polymorph_random.png")),
    DROPTELEPORT(SettingType.TOGGLE, 2, 100, UseType.PASSIVE, BindingType.CUSTOM_ONLY, CustomSettingType.RENDER, (Holder<Item>)Registration.UPGRADE_DROPTELEPORT),
    VOIDSHIFT(SettingType.SLIDER, 1, 50, UseType.USE, BindingType.LEFT_AND_CUSTOM, AbilityMethods::voidShift, CustomSettingType.RENDER),
    NEGATEFALLDAMAGE(SettingType.SLIDER, 1, 50, UseType.PASSIVE, BindingType.CUSTOM_ONLY, (Holder<Item>)Registration.UPGRADE_NEGATEFALLDAMAGE),
    NIGHTVISION(SettingType.SLIDER, 1, 25, UseType.PASSIVE, BindingType.CUSTOM_ONLY, (Holder<Item>)Registration.UPGRADE_NIGHTVISION),
    ELYTRA(SettingType.SLIDER, 1, 1000, UseType.PASSIVE, BindingType.CUSTOM_ONLY, (Holder<Item>)Registration.UPGRADE_ELYTRA),
    DECOY(SettingType.SLIDER, 25, 5000, UseType.USE_COOLDOWN, BindingType.CUSTOM_ONLY, AbilityMethods::decoy, CustomSettingType.NONE, ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/overlay/decoy.png"), (Holder<Item>)Registration.UPGRADE_DECOY),
    LINGERING(SettingType.TOGGLE, 50, 1000, UseType.PASSIVE, BindingType.CUSTOM_ONLY, (Holder<Item>)Registration.UPGRADE_LINGERING),
    HOMING(SettingType.TOGGLE, 50, 2000, UseType.PASSIVE, BindingType.CUSTOM_ONLY, CustomSettingType.TARGET, (Holder<Item>)Registration.UPGRADE_HOMING),
    WATERBREATHING(SettingType.TOGGLE, 50, 500, UseType.PASSIVE_TICK, BindingType.CUSTOM_ONLY, AbilityMethods::waterBreathing, CustomSettingType.NONE, (Holder<Item>)Registration.UPGRADE_WATERBREATHING),
    OREXRAY(SettingType.TOGGLE, 100, 5000, UseType.USE, BindingType.LEFT_AND_CUSTOM, AbilityMethods::scanForOreXRAY, CustomSettingType.NONE, (Holder<Item>)Registration.UPGRADE_OREXRAY),
    GLOWING(SettingType.TOGGLE, 100, 5000, UseType.USE, BindingType.LEFT_AND_CUSTOM, AbilityMethods::glowing, CustomSettingType.NONE, (Holder<Item>)Registration.UPGRADE_GLOWING),
    INSTABREAK(SettingType.TOGGLE, 2, 250, UseType.PASSIVE, BindingType.CUSTOM_ONLY, (Holder<Item>)Registration.UPGRADE_INSTABREAK),
    ECLIPSEGATE(SettingType.SLIDER, 1, 250, UseType.USE_ON, BindingType.LEFT_AND_CUSTOM, AbilityMethods::eclipseGate, CustomSettingType.NONE),
    DEATHPROTECTION(SettingType.SLIDER, 25, 450000, UseType.PASSIVE_COOLDOWN, BindingType.CUSTOM_ONLY, CustomSettingType.NONE, ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/overlay/deathprotection.png"), (Holder<Item>)Registration.UPGRADE_DEATHPROTECTION),
    DEBUFFREMOVER(SettingType.SLIDER, 25, 50000, UseType.USE_COOLDOWN, BindingType.CUSTOM_ONLY, AbilityMethods::debuffRemover, CustomSettingType.NONE, ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/overlay/debuffremover.png"), (Holder<Item>)Registration.UPGRADE_DEBUFFREMOVER),
    EARTHQUAKE(SettingType.SLIDER, 25, 50000, UseType.USE_COOLDOWN, BindingType.CUSTOM_ONLY, AbilityMethods::earthquake, CustomSettingType.NONE, ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/overlay/earthquake.png"), (Holder<Item>)Registration.UPGRADE_EARTHQUAKE),
    NOAI(SettingType.SLIDER, 25, 100000, UseType.USE_COOLDOWN, BindingType.CUSTOM_ONLY, AbilityMethods::noAI, CustomSettingType.NONE, ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/overlay/noai.png"), (Holder<Item>)Registration.UPGRADE_NOAI),
    FLIGHT(SettingType.SLIDER, 1, 100, UseType.PASSIVE_TICK, BindingType.CUSTOM_ONLY, AbilityMethods::flight, CustomSettingType.NONE, (Holder<Item>)Registration.UPGRADE_FLIGHT),
    LAVAIMMUNITY(SettingType.SLIDER, 1, 1000, UseType.PASSIVE, BindingType.CUSTOM_ONLY, (Holder<Item>)Registration.UPGRADE_LAVAIMMUNITY),
    PHASE(SettingType.SLIDER, 1, 50000, UseType.PASSIVE, BindingType.CUSTOM_ONLY, (Holder<Item>)Registration.UPGRADE_PHASE),
    TIMEPROTECTION(SettingType.SLIDER, 1, 5000, UseType.PASSIVE, BindingType.CUSTOM_ONLY, (Holder<Item>)Registration.UPGRADE_TIMEPROTECTION),
    POLYMORPH_TARGET(SettingType.TOGGLE, 10, 50000, UseType.USE, BindingType.LEFT_AND_CUSTOM, AbilityMethods::polymorphTarget, CustomSettingType.NONE, ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/overlay/polymorph_target.png")),
    EPICARROW(SettingType.SLIDER, 25, 100000, UseType.USE_COOLDOWN, BindingType.CUSTOM_ONLY, AbilityMethods::epicArrow, CustomSettingType.NONE, ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/overlay/epicarrow.png"), (Holder<Item>)Registration.UPGRADE_EPICARROW);

    final String name = this.name().toLowerCase(Locale.ROOT);
    final String localization;
    final SettingType settingType;
    final ResourceLocation iconLocation;
    final int durabilityCost;
    final int feCost;
    final BindingType bindingType;
    final CustomSettingType customSettingType;
    final UseType useType;
    private Holder<Item> upgradeItem;
    private static final Map<Ability, AbilityParams> dynamicParams;
    public AbilityAction action;
    public UseOnAbilityAction useOnAction;
    private ResourceLocation cooldownIcon;

    private Ability(SettingType settingType, int durabilityCost, int feCost, UseType useType, BindingType bindingType, CustomSettingType customSettingType) {
        this.settingType = settingType;
        this.localization = "justdirethings.ability." + this.name;
        this.iconLocation = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)("textures/gui/buttons/" + this.name + ".png"));
        this.durabilityCost = durabilityCost;
        this.feCost = feCost;
        this.bindingType = bindingType;
        this.customSettingType = customSettingType;
        this.useType = useType;
    }

    private Ability(SettingType settingType, int durabilityCost, int feCost, UseType useType, BindingType bindingType) {
        this(settingType, durabilityCost, feCost, useType, bindingType, CustomSettingType.NONE);
    }

    private Ability(SettingType settingType, int durabilityCost, int feCost, UseType useType, BindingType bindingType, Holder<Item> upgradeItem) {
        this(settingType, durabilityCost, feCost, useType, bindingType, CustomSettingType.NONE);
        this.upgradeItem = upgradeItem;
    }

    private Ability(SettingType settingType, int durabilityCost, int feCost, UseType useType, BindingType bindingType, CustomSettingType customSettingType, Holder<Item> upgradeItem) {
        this(settingType, durabilityCost, feCost, useType, bindingType, customSettingType);
        this.upgradeItem = upgradeItem;
    }

    private Ability(SettingType settingType, int durabilityCost, int feCost, UseType useType, BindingType bindingType, AbilityAction action, CustomSettingType customSettingType) {
        this(settingType, durabilityCost, feCost, useType, bindingType, customSettingType);
        this.action = action;
    }

    private Ability(SettingType settingType, int durabilityCost, int feCost, UseType useType, BindingType bindingType, AbilityAction action, CustomSettingType customSettingType, Holder<Item> upgradeItem) {
        this(settingType, durabilityCost, feCost, useType, bindingType, customSettingType);
        this.action = action;
        this.upgradeItem = upgradeItem;
    }

    private Ability(SettingType settingType, int durabilityCost, int feCost, UseType useType, BindingType bindingType, CustomSettingType customSettingType, ResourceLocation cooldownIcon) {
        this(settingType, durabilityCost, feCost, useType, bindingType, customSettingType);
        this.cooldownIcon = cooldownIcon;
    }

    private Ability(SettingType settingType, int durabilityCost, int feCost, UseType useType, BindingType bindingType, CustomSettingType customSettingType, ResourceLocation cooldownIcon, Holder<Item> upgradeItem) {
        this(settingType, durabilityCost, feCost, useType, bindingType, customSettingType);
        this.cooldownIcon = cooldownIcon;
        this.upgradeItem = upgradeItem;
    }

    private Ability(SettingType settingType, int durabilityCost, int feCost, UseType useType, BindingType bindingType, AbilityAction action, CustomSettingType customSettingType, ResourceLocation cooldownIcon) {
        this(settingType, durabilityCost, feCost, useType, bindingType, customSettingType);
        this.action = action;
        this.cooldownIcon = cooldownIcon;
    }

    private Ability(SettingType settingType, int durabilityCost, int feCost, UseType useType, BindingType bindingType, AbilityAction action, CustomSettingType customSettingType, ResourceLocation cooldownIcon, Holder<Item> upgradeItem) {
        this(settingType, durabilityCost, feCost, useType, bindingType, customSettingType);
        this.action = action;
        this.cooldownIcon = cooldownIcon;
        this.upgradeItem = upgradeItem;
    }

    private Ability(SettingType settingType, int durabilityCost, int feCost, UseType useType, BindingType bindingType, UseOnAbilityAction useOnAction, CustomSettingType customSettingType) {
        this(settingType, durabilityCost, feCost, useType, bindingType, customSettingType);
        this.useOnAction = useOnAction;
    }

    private Ability(SettingType settingType, int durabilityCost, int feCost, UseType useType, BindingType bindingType, UseOnAbilityAction useOnAction, CustomSettingType customSettingType, Holder<Item> upgradeItem) {
        this(settingType, durabilityCost, feCost, useType, bindingType, customSettingType);
        this.useOnAction = useOnAction;
        this.upgradeItem = upgradeItem;
    }

    public boolean hasDynamicParams(Ability toolAbility) {
        return dynamicParams.containsKey((Object)toolAbility);
    }

    public String getLocalization() {
        return this.localization;
    }

    public String getName() {
        return this.name;
    }

    public SettingType getSettingType() {
        return this.settingType;
    }

    public ResourceLocation getIconLocation() {
        return this.iconLocation;
    }

    public int getDurabilityCost() {
        return this.durabilityCost;
    }

    public int getFeCost() {
        return this.feCost;
    }

    public boolean isBindable() {
        return this.bindingType != BindingType.NONE;
    }

    public BindingType getBindingType() {
        return this.bindingType;
    }

    public boolean hasCustomSetting() {
        return this.customSettingType != CustomSettingType.NONE;
    }

    public CustomSettingType getCustomSetting() {
        return this.customSettingType;
    }

    public static Ability byName(String name) {
        return Ability.valueOf(name.toUpperCase(Locale.ROOT));
    }

    public ResourceLocation getCooldownIcon() {
        return this.cooldownIcon;
    }

    public boolean requiresUpgrade() {
        return this.upgradeItem != null;
    }

    public Holder<Item> getUpgradeItem() {
        return this.upgradeItem;
    }

    public static Ability getAbilityFromUpgradeItem(Item item) {
        for (Ability ability : Ability.values()) {
            if (ability.getUpgradeItem() == null || ability.getUpgradeItem().value() != item) continue;
            return ability;
        }
        return null;
    }

    static {
        dynamicParams = new EnumMap<Ability, AbilityParams>(Ability.class);
    }

    public static enum SettingType {
        TOGGLE,
        SLIDER,
        CYCLE;

    }

    public static enum BindingType {
        NONE,
        CUSTOM_ONLY,
        LEFT_AND_CUSTOM;

    }

    public static enum CustomSettingType {
        NONE,
        RENDER,
        TARGET;

    }

    public static enum UseType {
        USE,
        USE_ON,
        USE_COOLDOWN,
        PASSIVE,
        PASSIVE_TICK,
        PASSIVE_COOLDOWN,
        PASSIVE_TICK_COOLDOWN;

    }

    @FunctionalInterface
    public static interface AbilityAction {
        public boolean execute(Level var1, Player var2, ItemStack var3);
    }

    @FunctionalInterface
    public static interface UseOnAbilityAction {
        public boolean execute(UseOnContext var1);
    }
}

