/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items;

import com.direwolf20.justdirethings.common.containers.PotionCanisterContainer;
import com.direwolf20.justdirethings.common.containers.handlers.PotionCanisterHandler;
import com.direwolf20.justdirethings.common.items.datacomponents.JustDireDataComponents;
import com.direwolf20.justdirethings.util.MagicHelpers;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PotionCanister
extends Item {
    public PotionCanister() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new PotionCanisterContainer(windowId, playerInventory, player, itemstack), (Component)Component.translatable((String)"")), buf -> ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)itemstack));
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Level level = context.level();
        if (level == null) {
            return;
        }
        PotionContents potionContents = PotionCanister.getPotionContents(stack);
        int potionAmt = PotionCanister.getPotionAmount(stack);
        if (potionAmt == 0 || potionContents.equals((Object)PotionContents.EMPTY)) {
            return;
        }
        tooltip.add((Component)Component.literal((String)(MagicHelpers.formatted(potionAmt) + "/" + MagicHelpers.formatted(PotionCanister.getMaxMB()))));
        potionContents.addPotionTooltip(tooltip::add, 1.0f, 20.0f);
    }

    public static int getMaxMB() {
        return 1000;
    }

    public static PotionContents getPotionContents(ItemStack itemStack) {
        return (PotionContents)itemStack.getOrDefault(JustDireDataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
    }

    public static void setPotionContents(ItemStack itemStack, PotionContents potionContents) {
        itemStack.set(JustDireDataComponents.POTION_CONTENTS, (Object)potionContents);
    }

    public static void attemptFill(ItemStack canister) {
        int currentAmt;
        if (!(canister.getItem() instanceof PotionCanister)) {
            return;
        }
        PotionCanisterHandler handler = new PotionCanisterHandler(canister, (DataComponentType<ItemContainerContents>)((DataComponentType)JustDireDataComponents.TOOL_CONTENTS.get()), 1);
        ItemStack potion = handler.getStackInSlot(0);
        if (potion.isEmpty() || !(potion.getItem() instanceof PotionItem)) {
            return;
        }
        PotionContents currentContents = PotionCanister.getPotionContents(canister);
        PotionContents newContents = (PotionContents)potion.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        if ((currentContents.equals((Object)PotionContents.EMPTY) || currentContents.equals((Object)newContents)) && (currentAmt = PotionCanister.getPotionAmount(canister)) + 250 <= PotionCanister.getMaxMB()) {
            PotionCanister.setPotionContents(canister, newContents);
            PotionCanister.addPotionAmount(canister, 250);
            handler.setStackInSlot(0, new ItemStack((ItemLike)Items.GLASS_BOTTLE));
        }
    }

    public static int getPotionAmount(ItemStack itemStack) {
        return (Integer)itemStack.getOrDefault(JustDireDataComponents.POTION_AMOUNT, (Object)0);
    }

    public static void addPotionAmount(ItemStack itemStack, int amt) {
        PotionCanister.setPotionAmount(itemStack, PotionCanister.getPotionAmount(itemStack) + amt);
    }

    public static void setPotionAmount(ItemStack itemStack, int amt) {
        itemStack.set(JustDireDataComponents.POTION_AMOUNT, (Object)Math.max(0, Math.min(PotionCanister.getMaxMB(), amt)));
        if (PotionCanister.getPotionAmount(itemStack) == 0) {
            PotionCanister.setPotionContents(itemStack, PotionContents.EMPTY);
        }
    }

    public static void reducePotionAmount(ItemStack itemStack, int amt) {
        PotionCanister.setPotionAmount(itemStack, PotionCanister.getPotionAmount(itemStack) - amt);
    }

    public static int getFullness(ItemStack itemStack) {
        int potionAmt = PotionCanister.getPotionAmount(itemStack);
        if (potionAmt == 0) {
            return 0;
        }
        if (potionAmt > 0 && potionAmt <= 250) {
            return 1;
        }
        if (potionAmt > 250 && potionAmt <= 500) {
            return 2;
        }
        if (potionAmt > 500 && potionAmt <= 750) {
            return 3;
        }
        return 4;
    }

    public static int getPotionColor(ItemStack itemStack) {
        return PotionCanister.getPotionContents(itemStack).getColor();
    }
}

