/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.entities;

import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.MiscTools;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class TimeWandEntity
extends Entity {
    private static final EntityDataAccessor<Integer> TICKSPEED = SynchedEntityData.defineId(TimeWandEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> REMAINING_TIME = SynchedEntityData.defineId(TimeWandEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TOTAL_TIME = SynchedEntityData.defineId(TimeWandEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private BlockPos blockPos;

    public TimeWandEntity(EntityType<? extends Entity> entityType, Level level) {
        super(entityType, level);
    }

    public TimeWandEntity(Level level, BlockPos blockPos) {
        this((EntityType<? extends Entity>)((EntityType)Registration.TimeWandEntity.get()), level);
        this.blockPos = blockPos;
        this.moveTo((double)blockPos.getX() + 0.5, blockPos.getY(), (double)blockPos.getZ() + 0.5);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (!this.canSurvive()) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
            this.doExtraTicks();
            this.tickLife();
        }
    }

    public boolean canSurvive() {
        if (this.blockPos == null) {
            return false;
        }
        return this.getRemainingTime() >= 0;
    }

    public void doExtraTicks() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MiscTools.doExtraTicks(serverLevel, this.blockPos, this.getAccelerationRate());
        }
    }

    public void tickLife() {
        this.setRemainingTime(this.getRemainingTime() - 1);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(TICKSPEED, (Object)1);
        builder.define(REMAINING_TIME, (Object)600);
        builder.define(TOTAL_TIME, (Object)600);
    }

    public int getTickSpeed() {
        return (Integer)this.entityData.get(TICKSPEED);
    }

    public int getTotalTime() {
        return (Integer)this.entityData.get(TOTAL_TIME);
    }

    public float getAccelerationRate() {
        return TimeWandEntity.calculateAccelRate(this.getTickSpeed());
    }

    public static float calculateAccelRate(int speed) {
        return (float)Math.pow(2.0, speed);
    }

    public void setTickSpeed(int tickSpeed) {
        this.entityData.set(TICKSPEED, (Object)tickSpeed);
    }

    public void setTotalTime(int totalTime) {
        this.entityData.set(TOTAL_TIME, (Object)totalTime);
    }

    public int getRemainingTime() {
        return (Integer)this.entityData.get(REMAINING_TIME);
    }

    public void setRemainingTime(int remainingTime) {
        this.entityData.set(REMAINING_TIME, (Object)remainingTime);
    }

    public void addTime(int moreTime) {
        this.entityData.set(REMAINING_TIME, (Object)(this.getRemainingTime() + moreTime));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("tickSpeed")) {
            this.entityData.set(TICKSPEED, (Object)compound.getInt("tickSpeed"));
        }
        if (compound.contains("remainingTime")) {
            this.entityData.set(REMAINING_TIME, (Object)compound.getInt("remainingTime"));
        }
        if (compound.contains("totalTime")) {
            this.entityData.set(TOTAL_TIME, (Object)compound.getInt("totalTime"));
        }
        if (compound.contains("blockpos")) {
            this.blockPos = NbtUtils.readBlockPos((CompoundTag)compound, (String)"blockpos").orElse(null);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("tickSpeed", this.getTickSpeed());
        compound.putInt("remainingTime", this.getRemainingTime());
        if (this.blockPos != null) {
            compound.put("blockpos", NbtUtils.writeBlockPos((BlockPos)this.blockPos));
        }
        compound.putInt("totalTime", this.getTotalTime());
    }
}

