/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities;

import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.RedstoneControlledBE;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.MiscHelpers;
import com.direwolf20.justdirethings.util.interfacehelpers.RedstoneControlData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class DropperT1BE
extends BaseMachineBE
implements RedstoneControlledBE {
    public RedstoneControlData redstoneControlData = new RedstoneControlData();
    public int dropCount = 1;
    public int pickupDelay = 0;
    public List<Integer> slotsToDropList = new ArrayList<Integer>();

    public DropperT1BE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.MACHINE_SLOTS = 1;
    }

    public DropperT1BE(BlockPos pPos, BlockState pBlockState) {
        this((BlockEntityType)Registration.DropperT1BE.get(), pPos, pBlockState);
    }

    public void setDropperSettings(int dropCount, int pickupDelay) {
        this.dropCount = dropCount;
        this.pickupDelay = pickupDelay;
        this.markDirtyClient();
    }

    @Override
    public RedstoneControlData getRedstoneControlData() {
        return this.redstoneControlData;
    }

    @Override
    public BlockEntity getBlockEntity() {
        return this;
    }

    @Override
    public void tickClient() {
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.doDrop();
    }

    public boolean clearTrackerIfNeeded() {
        if (this.slotsToDropList.isEmpty()) {
            return false;
        }
        if (!this.canDrop()) {
            return true;
        }
        return !this.isActiveRedstone() && !this.redstoneControlData.redstoneMode.equals((Object)MiscHelpers.RedstoneMode.PULSE);
    }

    public void populateDropSlots() {
        for (int slot = 0; slot < this.getMachineHandler().getSlots(); ++slot) {
            ItemStack itemStack = this.getMachineHandler().getStackInSlot(slot);
            if (itemStack.isEmpty()) continue;
            this.slotsToDropList.add(slot);
            return;
        }
    }

    public boolean canDrop() {
        return true;
    }

    @Override
    public boolean isActiveRedstone() {
        if (this.getRedstoneControlData().redstoneMode.equals((Object)MiscHelpers.RedstoneMode.IGNORED)) {
            return true;
        }
        if (this.getRedstoneControlData().redstoneMode.equals((Object)MiscHelpers.RedstoneMode.LOW)) {
            return !this.getRedstoneControlData().receivingRedstone;
        }
        if (this.getRedstoneControlData().redstoneMode.equals((Object)MiscHelpers.RedstoneMode.HIGH)) {
            return this.getRedstoneControlData().receivingRedstone;
        }
        if (this.getRedstoneControlData().redstoneMode.equals((Object)MiscHelpers.RedstoneMode.PULSE) && this.getRedstoneControlData().pulsed) {
            this.getRedstoneControlData().pulsed = false;
            if (this.slotsToDropList.isEmpty()) {
                this.operationTicks = 0;
            }
            return true;
        }
        return false;
    }

    public void doDrop() {
        if (this.clearTrackerIfNeeded()) {
            this.slotsToDropList.clear();
            return;
        }
        if (!this.canDrop()) {
            return;
        }
        if (this.isActiveRedstone() && this.canRun() && this.slotsToDropList.isEmpty()) {
            this.populateDropSlots();
        }
        if (this.slotsToDropList.isEmpty()) {
            return;
        }
        if (this.operationTicks == 0) {
            ItemStack dropStack = this.getMachineHandler().getStackInSlot(this.slotsToDropList.remove(0).intValue());
            if (dropStack.isEmpty()) {
                this.slotsToDropList.clear();
                return;
            }
            BlockPos dropPos = this.getDropPos();
            if (dropPos == null) {
                return;
            }
            this.spawnItem(this.level, dropStack.split(this.dropCount), 0.3, Direction.values()[this.direction], new Vec3((double)dropPos.getX() + 0.5, (double)dropPos.getY() + 0.5, (double)dropPos.getZ() + 0.5));
        }
    }

    public void spawnItem(Level level, ItemStack stack, double speed, Direction direction, Vec3 position) {
        double d0 = position.x();
        double d1 = position.y();
        double d2 = position.z();
        ItemEntity itementity = new ItemEntity(level, d0, d1, d2, stack);
        itementity.setDeltaMovement((double)direction.getStepX() * speed, (double)direction.getStepY() * speed, (double)direction.getStepZ() * speed);
        itementity.setPickUpDelay(this.pickupDelay);
        level.addFreshEntity((Entity)itementity);
    }

    public boolean isBlockPosValid(BlockPos blockPos) {
        return true;
    }

    public BlockPos getDropPos() {
        BlockPos blockPos = this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING));
        if (this.isBlockPosValid(blockPos)) {
            return blockPos;
        }
        return null;
    }

    @Override
    public boolean isDefaultSettings() {
        if (!super.isDefaultSettings()) {
            return false;
        }
        if (this.dropCount != 1) {
            return false;
        }
        return this.pickupDelay == 0;
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("dropCount", this.dropCount);
        tag.putInt("pickupDelay", this.pickupDelay);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.dropCount = tag.getInt("dropCount");
        this.pickupDelay = tag.getInt("pickupDelay");
    }
}

