/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities;

import com.direwolf20.justdirethings.common.blockentities.BlockBreakerT1BE;
import com.direwolf20.justdirethings.common.blockentities.basebe.AreaAffectingBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FilterableBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineContainerData;
import com.direwolf20.justdirethings.common.capabilities.MachineEnergyStorage;
import com.direwolf20.justdirethings.common.containers.handlers.FilterBasicHandler;
import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.Helpers;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.interfacehelpers.AreaAffectingData;
import com.direwolf20.justdirethings.util.interfacehelpers.FilterData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;

public class BlockBreakerT2BE
extends BlockBreakerT1BE
implements PoweredMachineBE,
AreaAffectingBE,
FilterableBE {
    public FilterData filterData = new FilterData(false, false, 0);
    public AreaAffectingData areaAffectingData = new AreaAffectingData((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING));
    public final PoweredMachineContainerData poweredMachineData = new PoweredMachineContainerData(this);

    public BlockBreakerT2BE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)Registration.BlockBreakerT2BE.get(), pPos, pBlockState);
    }

    @Override
    public PoweredMachineContainerData getContainerData() {
        return this.poweredMachineData;
    }

    @Override
    public MachineEnergyStorage getEnergyStorage() {
        return (MachineEnergyStorage)((Object)this.getData(Registration.ENERGYSTORAGE_MACHINES));
    }

    @Override
    public int getStandardEnergyCost() {
        return 500;
    }

    @Override
    public AreaAffectingData getAreaAffectingData() {
        return this.areaAffectingData;
    }

    @Override
    public FilterBasicHandler getFilterHandler() {
        return (FilterBasicHandler)((Object)this.getData(Registration.HANDLER_BASIC_FILTER));
    }

    @Override
    public FilterData getFilterData() {
        return this.filterData;
    }

    @Override
    public FilterData getDefaultFilterData() {
        return new FilterData(false, false, 0);
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.chargeItemStack(this.getMachineHandler().getStackInSlot(0));
    }

    @Override
    public boolean canMine() {
        return this.hasEnoughPower(this.getStandardEnergyCost());
    }

    @Override
    public boolean tryBreakBlock(ItemStack tool, FakePlayer fakePlayer, BlockPos breakPos, BlockState blockState) {
        if (this.extractEnergy(this.getStandardEnergyCost(), false) < this.getStandardEnergyCost()) {
            return false;
        }
        return super.tryBreakBlock(tool, fakePlayer, breakPos, blockState);
    }

    @Override
    public Direction getFacing() {
        return this.getDirectionValue();
    }

    @Override
    public List<BlockPos> findBlocksToMine(FakePlayer fakePlayer) {
        AABB area = this.getAABB(this.getBlockPos());
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        BlockPos originPos = this.getBlockPos();
        Iterable positions = BlockPos.betweenClosed((int)((int)area.minX), (int)((int)area.minY), (int)((int)area.minZ), (int)((int)area.maxX - 1), (int)((int)area.maxY - 1), (int)((int)area.maxZ - 1));
        for (BlockPos blockPos : positions) {
            if (!this.isBlockValid(fakePlayer, blockPos)) continue;
            blockPositions.add(blockPos.immutable());
        }
        blockPositions.sort(Comparator.comparingDouble(pos -> pos.distSqr((Vec3i)originPos)));
        return blockPositions;
    }

    @Override
    public boolean isBlockValid(FakePlayer fakePlayer, BlockPos blockPos) {
        if (!super.isBlockValid(fakePlayer, blockPos)) {
            return false;
        }
        if (this.filterData.blockItemFilter == 0) {
            ItemStack blockItemStack = this.level.getBlockState(blockPos).getCloneItemStack((HitResult)new BlockHitResult(Vec3.ZERO, Direction.UP, blockPos, false), (LevelReader)this.level, blockPos, (Player)fakePlayer);
            return this.isStackValidFilter(blockItemStack);
        }
        ItemStack tool = this.getTool();
        List drops = Block.getDrops((BlockState)this.level.getBlockState(blockPos), (ServerLevel)((ServerLevel)this.level), (BlockPos)blockPos, (BlockEntity)this.level.getBlockEntity(blockPos), (Entity)fakePlayer, (ItemStack)tool);
        for (ItemStack drop : drops) {
            ToggleableTool toggleableTool;
            Item item = tool.getItem();
            if (!(item instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).canUseAbility(tool, Ability.SMELTER) ? this.isStackValidFilter(Helpers.getSmeltedItem(this.level, drop)) : this.isStackValidFilter(drop))) continue;
            return true;
        }
        return false;
    }
}

