/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.renderers;

import com.direwolf20.justdirethings.client.renderers.OurRenderTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;

public class RenderHelpers {
    public static final ResourceLocation DUMMY_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"white");
    private static float dummyU0 = 0.0f;
    private static float dummyU1 = 1.0f;
    private static float dummyV0 = 0.0f;
    private static float dummyV1 = 1.0f;

    public static void renderLines(PoseStack matrix, BlockPos startPos, BlockPos endPos, Color color, MultiBufferSource buffer) {
        int x = Math.min(startPos.getX(), endPos.getX());
        int y = Math.min(startPos.getY(), endPos.getY());
        int z = Math.min(startPos.getZ(), endPos.getZ());
        int dx = startPos.getX() > endPos.getX() ? startPos.getX() + 1 : endPos.getX() + 1;
        int dy = startPos.getY() > endPos.getY() ? startPos.getY() + 1 : endPos.getY() + 1;
        int dz = startPos.getZ() > endPos.getZ() ? startPos.getZ() + 1 : endPos.getZ() + 1;
        VertexConsumer builder = buffer.getBuffer(OurRenderTypes.lines());
        matrix.pushPose();
        Matrix4f matrix4f = matrix.last().pose();
        PoseStack.Pose matrix3f = matrix.last();
        int colorRGB = color.getRGB();
        builder.addVertex(matrix4f, (float)x, (float)y, (float)z).setColor(colorRGB).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)y, (float)z).setColor(colorRGB).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, (float)x, (float)y, (float)z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, (float)x, (float)dy, (float)z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, (float)x, (float)y, (float)z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix4f, (float)x, (float)y, (float)dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix4f, (float)dx, (float)y, (float)z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)dy, (float)z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)dy, (float)z).setColor(colorRGB).setNormal(matrix3f, -1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, (float)x, (float)dy, (float)z).setColor(colorRGB).setNormal(matrix3f, -1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, (float)x, (float)dy, (float)z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix4f, (float)x, (float)dy, (float)dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix4f, (float)x, (float)dy, (float)dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, -1.0f, 0.0f);
        builder.addVertex(matrix4f, (float)x, (float)y, (float)dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, -1.0f, 0.0f);
        builder.addVertex(matrix4f, (float)x, (float)y, (float)dz).setColor(colorRGB).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)y, (float)dz).setColor(colorRGB).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)y, (float)dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, -1.0f);
        builder.addVertex(matrix4f, (float)dx, (float)y, (float)z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, -1.0f);
        builder.addVertex(matrix4f, (float)x, (float)dy, (float)dz).setColor(colorRGB).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)dy, (float)dz).setColor(colorRGB).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)y, (float)dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)dy, (float)dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)dy, (float)z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix4f, (float)dx, (float)dy, (float)dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
        matrix.popPose();
    }

    public static void renderLines(PoseStack matrix, AABB aabb, Color color, MultiBufferSource buffer) {
        float x = (float)aabb.minX;
        float y = (float)aabb.minY;
        float z = (float)aabb.minZ;
        float dx = (float)aabb.maxX;
        float dy = (float)aabb.maxY;
        float dz = (float)aabb.maxZ;
        VertexConsumer builder = buffer.getBuffer(OurRenderTypes.lines());
        matrix.pushPose();
        Matrix4f matrix4f = matrix.last().pose();
        PoseStack.Pose matrix3f = matrix.last();
        int colorRGB = color.getRGB();
        builder.addVertex(matrix4f, x, y, z).setColor(colorRGB).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, dx, y, z).setColor(colorRGB).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, x, y, z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, x, dy, z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, x, y, z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix4f, x, y, dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix4f, dx, y, z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, dx, dy, z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, dx, dy, z).setColor(colorRGB).setNormal(matrix3f, -1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, x, dy, z).setColor(colorRGB).setNormal(matrix3f, -1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, x, dy, z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix4f, x, dy, dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix4f, x, dy, dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, -1.0f, 0.0f);
        builder.addVertex(matrix4f, x, y, dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, -1.0f, 0.0f);
        builder.addVertex(matrix4f, x, y, dz).setColor(colorRGB).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, dx, y, dz).setColor(colorRGB).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, dx, y, dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, -1.0f);
        builder.addVertex(matrix4f, dx, y, z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, -1.0f);
        builder.addVertex(matrix4f, x, dy, dz).setColor(colorRGB).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, dx, dy, dz).setColor(colorRGB).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, dx, y, dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, dx, dy, dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, dx, dy, z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix4f, dx, dy, dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
        matrix.popPose();
    }

    public static void renderLines(PoseStack matrix, BlockPos startPos, BlockPos endPos, Color color) {
        int x = Math.min(startPos.getX(), endPos.getX());
        int y = Math.min(startPos.getY(), endPos.getY());
        int z = Math.min(startPos.getZ(), endPos.getZ());
        int dx = startPos.getX() > endPos.getX() ? startPos.getX() + 1 : endPos.getX() + 1;
        int dy = startPos.getY() > endPos.getY() ? startPos.getY() + 1 : endPos.getY() + 1;
        int dz = startPos.getZ() > endPos.getZ() ? startPos.getZ() + 1 : endPos.getZ() + 1;
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer builder = buffer.getBuffer(OurRenderTypes.lines());
        matrix.pushPose();
        Matrix4f matrix4f = matrix.last().pose();
        PoseStack.Pose matrix3f = matrix.last();
        int colorRGB = color.getRGB();
        builder.addVertex(matrix4f, (float)x, (float)y, (float)z).setColor(colorRGB).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)y, (float)z).setColor(colorRGB).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, (float)x, (float)y, (float)z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, (float)x, (float)dy, (float)z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, (float)x, (float)y, (float)z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix4f, (float)x, (float)y, (float)dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix4f, (float)dx, (float)y, (float)z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)dy, (float)z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)dy, (float)z).setColor(colorRGB).setNormal(matrix3f, -1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, (float)x, (float)dy, (float)z).setColor(colorRGB).setNormal(matrix3f, -1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, (float)x, (float)dy, (float)z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix4f, (float)x, (float)dy, (float)dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix4f, (float)x, (float)dy, (float)dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, -1.0f, 0.0f);
        builder.addVertex(matrix4f, (float)x, (float)y, (float)dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, -1.0f, 0.0f);
        builder.addVertex(matrix4f, (float)x, (float)y, (float)dz).setColor(colorRGB).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)y, (float)dz).setColor(colorRGB).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)y, (float)dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, -1.0f);
        builder.addVertex(matrix4f, (float)dx, (float)y, (float)z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, -1.0f);
        builder.addVertex(matrix4f, (float)x, (float)dy, (float)dz).setColor(colorRGB).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)dy, (float)dz).setColor(colorRGB).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)y, (float)dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)dy, (float)dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)dy, (float)z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix4f, (float)dx, (float)dy, (float)dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
        buffer.endBatch(OurRenderTypes.lines());
        matrix.popPose();
    }

    public static void renderBoxSolid(PoseStack pose, Matrix4f matrix, MultiBufferSource buffer, BlockPos pos, float r, float g, float b, float alpha) {
        double x = (double)pos.getX() - 0.001;
        double y = (double)pos.getY() - 0.001;
        double z = (double)pos.getZ() - 0.001;
        double xEnd = (double)pos.getX() + 1.0015;
        double yEnd = (double)pos.getY() + 1.0015;
        double zEnd = (double)pos.getZ() + 1.0015;
        RenderHelpers.renderBoxSolid(pose.last(), matrix, buffer, x, y, z, xEnd, yEnd, zEnd, r, g, b, alpha);
    }

    public static void renderFaceSolid(PoseStack pose, Matrix4f matrix, MultiBufferSource buffer, BlockPos pos, Direction direction, float r, float g, float b, float alpha) {
        double x = (double)pos.getX() - 0.001;
        double y = (double)pos.getY() - 0.001;
        double z = (double)pos.getZ() - 0.001;
        double xEnd = (double)pos.getX() + 1.0015;
        double yEnd = (double)pos.getY() + 1.0015;
        double zEnd = (double)pos.getZ() + 1.0015;
        switch (direction) {
            case DOWN: {
                RenderHelpers.renderBoxSolid(pose.last(), matrix, buffer, x, y - 0.001, z, xEnd, y, zEnd, r, g, b, alpha);
                break;
            }
            case UP: {
                RenderHelpers.renderBoxSolid(pose.last(), matrix, buffer, x, yEnd, z, xEnd, yEnd + 0.0015, zEnd, r, g, b, alpha);
                break;
            }
            case NORTH: {
                RenderHelpers.renderBoxSolid(pose.last(), matrix, buffer, x, y, z - 0.001, xEnd, yEnd, z, r, g, b, alpha);
                break;
            }
            case SOUTH: {
                RenderHelpers.renderBoxSolid(pose.last(), matrix, buffer, x, y, zEnd, xEnd, yEnd, zEnd + 0.0015, r, g, b, alpha);
                break;
            }
            case WEST: {
                RenderHelpers.renderBoxSolid(pose.last(), matrix, buffer, x - 0.001, y, z, x, yEnd, zEnd, r, g, b, alpha);
                break;
            }
            case EAST: {
                RenderHelpers.renderBoxSolid(pose.last(), matrix, buffer, xEnd, y, z, xEnd + 0.0015, yEnd, zEnd, r, g, b, alpha);
            }
        }
    }

    public static void renderBoxSolid(PoseStack pose, Matrix4f matrix, MultiBufferSource buffer, AABB aabb, float r, float g, float b, float alpha) {
        float minX = (float)aabb.minX;
        float minY = (float)aabb.minY;
        float minZ = (float)aabb.minZ;
        float maxX = (float)aabb.maxX;
        float maxY = (float)aabb.maxY;
        float maxZ = (float)aabb.maxZ;
        RenderHelpers.renderBoxSolid(pose.last(), matrix, buffer, minX, minY, minZ, maxX, maxY, maxZ, r, g, b, alpha);
    }

    public static void renderBoxSolidOpaque(PoseStack pose, Matrix4f matrix, MultiBufferSource buffer, AABB aabb, float r, float g, float b, float alpha) {
        float minX = (float)aabb.minX;
        float minY = (float)aabb.minY;
        float minZ = (float)aabb.minZ;
        float maxX = (float)aabb.maxX;
        float maxY = (float)aabb.maxY;
        float maxZ = (float)aabb.maxZ;
        RenderHelpers.renderBoxSolidOpaque(pose.last(), matrix, buffer, minX, minY, minZ, maxX, maxY, maxZ, r, g, b, alpha);
    }

    public static void renderBoxSolid(PoseStack.Pose pose, Matrix4f matrix, MultiBufferSource buffer, double x, double y, double z, double xEnd, double yEnd, double zEnd, float red, float green, float blue, float alpha) {
        VertexConsumer builder = buffer.getBuffer(OurRenderTypes.TRANSPARENT_BOX);
        float startX = (float)x;
        float startY = (float)y;
        float startZ = (float)z;
        float endX = (float)xEnd;
        float endY = (float)yEnd;
        float endZ = (float)zEnd;
        builder.addVertex(matrix, startX, startY, startZ).setColor(red, green, blue, alpha).setUv(dummyU0, dummyV0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, endX, startY, startZ).setColor(red, green, blue, alpha).setUv(dummyU0, dummyV1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, endX, startY, endZ).setColor(red, green, blue, alpha).setUv(dummyU1, dummyV1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, startX, startY, endZ).setColor(red, green, blue, alpha).setUv(dummyU1, dummyV0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, startX, endY, startZ).setColor(red, green, blue, alpha).setUv(dummyU0, dummyV0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, startX, endY, endZ).setColor(red, green, blue, alpha).setUv(dummyU0, dummyV1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, endX, endY, endZ).setColor(red, green, blue, alpha).setUv(dummyU1, dummyV1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, endX, endY, startZ).setColor(red, green, blue, alpha).setUv(dummyU1, dummyV0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, startX, startY, startZ).setColor(red, green, blue, alpha).setUv(dummyU0, dummyV0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, startX, endY, startZ).setColor(red, green, blue, alpha).setUv(dummyU0, dummyV1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, endX, endY, startZ).setColor(red, green, blue, alpha).setUv(dummyU1, dummyV1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, endX, startY, startZ).setColor(red, green, blue, alpha).setUv(dummyU1, dummyV0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, startX, startY, endZ).setColor(red, green, blue, alpha).setUv(dummyU0, dummyV0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, endX, startY, endZ).setColor(red, green, blue, alpha).setUv(dummyU0, dummyV1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, endX, endY, endZ).setColor(red, green, blue, alpha).setUv(dummyU1, dummyV1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, startX, endY, endZ).setColor(red, green, blue, alpha).setUv(dummyU1, dummyV0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, endX, startY, startZ).setColor(red, green, blue, alpha).setUv(dummyU0, dummyV0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, endX, endY, startZ).setColor(red, green, blue, alpha).setUv(dummyU0, dummyV1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, endX, endY, endZ).setColor(red, green, blue, alpha).setUv(dummyU1, dummyV1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, endX, startY, endZ).setColor(red, green, blue, alpha).setUv(dummyU1, dummyV0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, startX, startY, startZ).setColor(red, green, blue, alpha).setUv(dummyU0, dummyV0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, startX, startY, endZ).setColor(red, green, blue, alpha).setUv(dummyU0, dummyV1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, startX, endY, endZ).setColor(red, green, blue, alpha).setUv(dummyU1, dummyV1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, startX, endY, startZ).setColor(red, green, blue, alpha).setUv(dummyU1, dummyV0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
    }

    public static void renderBoxSolidOpaque(PoseStack.Pose pose, Matrix4f matrix, MultiBufferSource buffer, double x, double y, double z, double xEnd, double yEnd, double zEnd, float red, float green, float blue, float alpha) {
        VertexConsumer builder = buffer.getBuffer((RenderType)RenderType.DEBUG_QUADS);
        float startX = (float)x;
        float startY = (float)y;
        float startZ = (float)z;
        float endX = (float)xEnd;
        float endY = (float)yEnd;
        float endZ = (float)zEnd;
        builder.addVertex(matrix, startX, startY, startZ).setColor(red, green, blue, alpha).setUv(dummyU0, dummyV0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, endX, startY, startZ).setColor(red, green, blue, alpha).setUv(dummyU0, dummyV1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, endX, startY, endZ).setColor(red, green, blue, alpha).setUv(dummyU1, dummyV1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, startX, startY, endZ).setColor(red, green, blue, alpha).setUv(dummyU1, dummyV0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, startX, endY, startZ).setColor(red, green, blue, alpha).setUv(dummyU0, dummyV0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, startX, endY, endZ).setColor(red, green, blue, alpha).setUv(dummyU0, dummyV1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, endX, endY, endZ).setColor(red, green, blue, alpha).setUv(dummyU1, dummyV1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, endX, endY, startZ).setColor(red, green, blue, alpha).setUv(dummyU1, dummyV0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, startX, startY, startZ).setColor(red, green, blue, alpha).setUv(dummyU0, dummyV0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, startX, endY, startZ).setColor(red, green, blue, alpha).setUv(dummyU0, dummyV1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, endX, endY, startZ).setColor(red, green, blue, alpha).setUv(dummyU1, dummyV1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, endX, startY, startZ).setColor(red, green, blue, alpha).setUv(dummyU1, dummyV0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, startX, startY, endZ).setColor(red, green, blue, alpha).setUv(dummyU0, dummyV0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, endX, startY, endZ).setColor(red, green, blue, alpha).setUv(dummyU0, dummyV1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, endX, endY, endZ).setColor(red, green, blue, alpha).setUv(dummyU1, dummyV1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, startX, endY, endZ).setColor(red, green, blue, alpha).setUv(dummyU1, dummyV0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, endX, startY, startZ).setColor(red, green, blue, alpha).setUv(dummyU0, dummyV0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, endX, endY, startZ).setColor(red, green, blue, alpha).setUv(dummyU0, dummyV1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, endX, endY, endZ).setColor(red, green, blue, alpha).setUv(dummyU1, dummyV1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, endX, startY, endZ).setColor(red, green, blue, alpha).setUv(dummyU1, dummyV0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, startX, startY, startZ).setColor(red, green, blue, alpha).setUv(dummyU0, dummyV0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, startX, startY, endZ).setColor(red, green, blue, alpha).setUv(dummyU0, dummyV1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, startX, endY, endZ).setColor(red, green, blue, alpha).setUv(dummyU1, dummyV1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix, startX, endY, startZ).setColor(red, green, blue, alpha).setUv(dummyU1, dummyV0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
    }

    public static void captureDummySprite(TextureAtlas atlas) {
        TextureAtlasSprite sprite = atlas.getSprite(DUMMY_TEXTURE);
        dummyU0 = sprite.getU0();
        dummyU1 = sprite.getU1();
        dummyV0 = sprite.getV0();
        dummyV1 = sprite.getV1();
    }

    public static void renderSphere(PoseStack poseStack, MultiBufferSource bufferSource, Color color, float radius, int light) {
        VertexConsumer builder = bufferSource.getBuffer(OurRenderTypes.TRIANGLE_STRIP);
        Matrix4f matrix = poseStack.last().pose();
        PoseStack.Pose matrixPose = poseStack.last();
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        int alpha = color.getAlpha();
        int latitudeBands = 16;
        int longitudeBands = 16;
        for (int latNumber = 0; latNumber <= latitudeBands; ++latNumber) {
            float theta1 = (float)((double)latNumber * Math.PI / (double)latitudeBands);
            float theta2 = (float)((double)(latNumber + 1) * Math.PI / (double)latitudeBands);
            float sinTheta1 = Mth.sin((float)theta1);
            float cosTheta1 = Mth.cos((float)theta1);
            float sinTheta2 = Mth.sin((float)theta2);
            float cosTheta2 = Mth.cos((float)theta2);
            for (int longNumber = 0; longNumber <= longitudeBands; ++longNumber) {
                float phi = (float)((double)(longNumber * 2) * Math.PI / (double)longitudeBands);
                float sinPhi = Mth.sin((float)phi);
                float cosPhi = Mth.cos((float)phi);
                float x1 = cosPhi * sinTheta1;
                float y1 = cosTheta1;
                float z1 = sinPhi * sinTheta1;
                float x2 = cosPhi * sinTheta2;
                float y2 = cosTheta2;
                float z2 = sinPhi * sinTheta2;
                builder.addVertex(matrix, x1 * radius, y1 * radius, z1 * radius).setColor(red, green, blue, alpha).setUv(dummyU0, dummyV0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(matrixPose, x1, y1, z1);
                builder.addVertex(matrix, x2 * radius, y2 * radius, z2 * radius).setColor(red, green, blue, alpha).setUv(dummyU1, dummyV1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(matrixPose, x2, y2, z2);
            }
        }
    }

    public static void renderVortex(PoseStack poseStack, MultiBufferSource bufferSource, int light, Color color, float maxRadius, int segments, int layers, int tickCount, float thickness, float heightFactor) {
        VertexConsumer vertexConsumer = bufferSource.getBuffer((RenderType)OurRenderTypes.LINES);
        Matrix4f matrix = poseStack.last().pose();
        PoseStack.Pose pose = poseStack.last();
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        int alpha = 255;
        float angleOffset = (float)(tickCount % 360) * (float)Math.PI / 180.0f;
        for (int layer = 0; layer < layers; ++layer) {
            float layerOffset = (float)layer * (float)Math.PI / (float)layers;
            for (int i = 0; i < segments; ++i) {
                float angle1 = (float)i / (float)segments * (float)Math.PI * 2.0f + angleOffset + layerOffset;
                float angle2 = (float)(i + 1) / (float)segments * (float)Math.PI * 2.0f + angleOffset + layerOffset;
                float radius1 = maxRadius * (float)(segments - i) / (float)segments;
                float radius2 = maxRadius * (float)(segments - i - 1) / (float)segments;
                float height1 = (float)i * heightFactor;
                float height2 = (float)(i + 1) * heightFactor;
                float x1 = radius1 * Mth.cos((float)angle1);
                float z1 = radius1 * Mth.sin((float)angle1);
                float x2 = radius2 * Mth.cos((float)angle2);
                float z2 = radius2 * Mth.sin((float)angle2);
                for (float offset = -thickness; offset <= thickness; offset += thickness / 2.0f) {
                    float offsetX1 = x1 + offset * Mth.sin((float)angle1);
                    float offsetZ1 = z1 - offset * Mth.cos((float)angle1);
                    float offsetX2 = x2 + offset * Mth.sin((float)angle2);
                    float offsetZ2 = z2 - offset * Mth.cos((float)angle2);
                    vertexConsumer.addVertex(matrix, offsetX1, height1, offsetZ1).setColor(red, green, blue, alpha).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, x1, height1, z1);
                    vertexConsumer.addVertex(matrix, offsetX2, height2, offsetZ2).setColor(red, green, blue, alpha).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, x2, height2, z2);
                }
            }
        }
    }
}

