/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.entityrenders;

import com.direwolf20.justdirethings.client.renderers.OurRenderTypes;
import com.direwolf20.justdirethings.client.renderers.RenderHelpers;
import com.direwolf20.justdirethings.common.entities.ParadoxEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class ParadoxEntityRender
extends EntityRenderer<ParadoxEntity> {
    private static final Random random = new Random();
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/entity/vortex1.png");
    private float savedPulseScale = -1.0f;

    public ParadoxEntityRender(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public ResourceLocation getTextureLocation(ParadoxEntity pEntity) {
        return TEXTURE;
    }

    public void render(ParadoxEntity paradoxEntity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.pushPose();
        matrixStackIn.pushPose();
        float currentRadius = paradoxEntity.getRadius() + 1;
        float targetRadius = paradoxEntity.getTargetRadius() + 1;
        int pulseCycleDuration = 50;
        float tickProgress = ((float)paradoxEntity.tickCount + partialTicks) % (float)pulseCycleDuration;
        float pulsePhase = tickProgress / (float)pulseCycleDuration;
        float pulseScale = 0.25f + 0.025f * (1.0f - Math.abs(2.0f * pulsePhase - 1.0f));
        if (paradoxEntity.getGrowthTicks() > 0) {
            if (this.savedPulseScale == -1.0f) {
                this.savedPulseScale = pulseScale;
            }
            float growthProgress = (float)paradoxEntity.getGrowthTicks() / (float)paradoxEntity.growthDuration;
            currentRadius = Mth.lerp((float)growthProgress, (float)currentRadius, (float)targetRadius);
        } else {
            this.savedPulseScale = -1.0f;
        }
        if (this.savedPulseScale != -1.0f) {
            pulseScale = this.savedPulseScale;
        }
        matrixStackIn.translate(0.0, 0.5, 0.0);
        float shrinkScale = paradoxEntity.getShrinkScale();
        matrixStackIn.scale(pulseScale * shrinkScale, pulseScale * shrinkScale, pulseScale * shrinkScale);
        RenderHelpers.renderSphere(matrixStackIn, bufferIn, Color.BLACK, 0.25f * (float)Math.pow(currentRadius, 1.25), packedLightIn);
        matrixStackIn.popPose();
        Color baseRed = new Color(100, 0, 0, 255);
        Color basePurple = new Color(75, 0, 0, 255);
        float mixRatio = random.nextFloat();
        int red = (int)((float)baseRed.getRed() * (1.0f - mixRatio) + (float)basePurple.getRed() * mixRatio);
        int green = (int)((float)baseRed.getGreen() * (1.0f - mixRatio) + (float)basePurple.getGreen() * mixRatio);
        int blue = (int)((float)baseRed.getBlue() * (1.0f - mixRatio) + (float)basePurple.getBlue() * mixRatio);
        this.renderLightning(paradoxEntity, matrixStackIn, bufferIn, packedLightIn, new Color(red, green, blue, 255), 0.025f, (float)Math.pow(paradoxEntity.getRadius() + 1, 1.25), 20, 0.7f, 5, 0.25f, 5, true);
        matrixStackIn.popPose();
    }

    private void renderLightning(ParadoxEntity paradoxEntity, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, Color color, float frequency, float maxLength, int duration, float thickness, int numBranches, float branchChance, int segments, boolean branchAnywhere) {
        Random random = new Random(paradoxEntity.tickCount);
        int i = 0;
        while ((float)i < frequency * 100.0f) {
            if (!(random.nextFloat() > frequency)) {
                matrixStackIn.pushPose();
                matrixStackIn.translate(0.0, 0.5, 0.0);
                float angle = random.nextFloat() * 360.0f;
                float pitch = random.nextFloat() * 180.0f - 90.0f;
                float length = random.nextFloat() * maxLength;
                float startX = 0.0f;
                float startY = 0.0f;
                float startZ = 0.0f;
                for (int segment = 0; segment < segments; ++segment) {
                    float segmentLength = length / (float)segments;
                    float x = startX + segmentLength * Mth.cos((float)((float)Math.toRadians(angle))) * Mth.cos((float)((float)Math.toRadians(pitch)));
                    float y = startY + segmentLength * Mth.sin((float)((float)Math.toRadians(pitch)));
                    float z = startZ + segmentLength * Mth.sin((float)((float)Math.toRadians(angle))) * Mth.cos((float)((float)Math.toRadians(pitch)));
                    VertexConsumer vertexConsumer = bufferIn.getBuffer((RenderType)OurRenderTypes.LINE_STRIP);
                    Matrix4f matrix = matrixStackIn.last().pose();
                    Vector3f normal = new Vector3f(0.0f, 1.0f, 0.0f);
                    vertexConsumer.addVertex(matrix, startX, startY, startZ).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLightIn).setNormal(matrixStackIn.last(), normal.x(), normal.y(), normal.z());
                    vertexConsumer.addVertex(matrix, x, y, z).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLightIn).setNormal(matrixStackIn.last(), normal.x(), normal.y(), normal.z());
                    startX = x;
                    startY = y;
                    startZ = z;
                    for (int branch = 0; branch < numBranches; ++branch) {
                        if (!(random.nextFloat() < branchChance) || !branchAnywhere && segment != segments - 1) continue;
                        this.renderBranch(matrixStackIn, bufferIn, packedLightIn, color, startX, startY, startZ, segmentLength, branchAnywhere ? random.nextInt(segments) : segment, random, normal);
                    }
                }
                matrixStackIn.popPose();
            }
            ++i;
        }
    }

    private void renderBranch(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, Color color, float startX, float startY, float startZ, float segmentLength, int segment, Random random, Vector3f normal) {
        float branchAngle = random.nextFloat() * 360.0f;
        float branchPitch = random.nextFloat() * 180.0f - 90.0f;
        float branchLength = segmentLength * (0.5f + random.nextFloat() * 0.5f);
        float bx = startX + branchLength * Mth.cos((float)((float)Math.toRadians(branchAngle))) * Mth.cos((float)((float)Math.toRadians(branchPitch)));
        float by = startY + branchLength * Mth.sin((float)((float)Math.toRadians(branchPitch)));
        float bz = startZ + branchLength * Mth.sin((float)((float)Math.toRadians(branchAngle))) * Mth.cos((float)((float)Math.toRadians(branchPitch)));
        VertexConsumer vertexConsumer = bufferIn.getBuffer((RenderType)OurRenderTypes.LINE_STRIP);
        Matrix4f matrix = matrixStackIn.last().pose();
        vertexConsumer.addVertex(matrix, startX, startY, startZ).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLightIn).setNormal(matrixStackIn.last(), normal.x(), normal.y(), normal.z());
        vertexConsumer.addVertex(matrix, bx, by, bz).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLightIn).setNormal(matrixStackIn.last(), normal.x(), normal.y(), normal.z());
    }
}

