/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.villagesandpillages.world.processor;

import com.faboslav.villagesandpillages.init.VillagesAndPillagesProcessorTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public final class CollapsedUnderwaterProcessor
extends StructureProcessor {
    public static final MapCodec<CollapsedUnderwaterProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockState.CODEC.fieldOf("target_block").forGetter(config -> config.targetBlock), (App)BlockState.CODEC.fieldOf("target_block_output").forGetter(config -> config.targetBlockOutput), (App)Direction.CODEC.optionalFieldOf("direction", (Object)Direction.DOWN).forGetter(processor -> processor.direction), (App)Codec.INT.optionalFieldOf("pillar_length", (Object)-1).forGetter(config -> config.length)).apply((Applicative)instance, instance.stable(CollapsedUnderwaterProcessor::new)));
    public final BlockState targetBlock;
    public final BlockState targetBlockOutput;
    public final Direction direction;
    public final int length;

    private CollapsedUnderwaterProcessor(BlockState targetBlock, BlockState targetBlockOutput, Direction direction, int length) {
        this.targetBlock = targetBlock;
        this.targetBlockOutput = targetBlockOutput;
        this.direction = direction;
        this.length = length;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader worldView, BlockPos pos, BlockPos pivot, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.state().is(this.targetBlock.getBlock())) {
            WorldGenRegion chunkRegion;
            if (worldView instanceof WorldGenRegion && !(chunkRegion = (WorldGenRegion)worldView).getCenter().equals((Object)new ChunkPos(blockInfoGlobal.pos()))) {
                return blockInfoGlobal;
            }
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), Blocks.AIR.defaultBlockState(), blockInfoGlobal.nbt());
            BlockPos.MutableBlockPos mutable = blockInfoGlobal.pos().mutable().move(Direction.DOWN);
            BlockState currentBlockState = worldView.getBlockState((BlockPos)mutable);
            RandomSource random = structurePlacementData.getRandom(blockInfoGlobal.pos());
            while (mutable.getY() > worldView.getMinBuildHeight() && mutable.getY() < worldView.getMaxBuildHeight() && (currentBlockState.isAir() || !worldView.getFluidState((BlockPos)mutable).isEmpty())) {
                if (!currentBlockState.isAir() && !worldView.getFluidState((BlockPos)mutable).isEmpty() && worldView.getFluidState(mutable.mutable().below()).isEmpty() && random.nextIntBetweenInclusive(0, 5) > 1) {
                    BlockState modifiedTargetBlockOutput = this.targetBlockOutput;
                    if (modifiedTargetBlockOutput.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                        modifiedTargetBlockOutput = (BlockState)this.targetBlockOutput.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                    }
                    worldView.getChunk((BlockPos)mutable).setBlockState((BlockPos)mutable, modifiedTargetBlockOutput, false);
                    break;
                }
                mutable.move(Direction.DOWN);
                currentBlockState = worldView.getBlockState((BlockPos)mutable);
            }
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> getType() {
        return VillagesAndPillagesProcessorTypes.COLLAPSED_UNDERWATER_PROCESSOR;
    }
}

