/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism.content;

import com.refinedmods.refinedstorage.mekanism.storage.ChemicalStorageVariant;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;

public final class Items {
    private static final Map<ChemicalStorageVariant, Supplier<Item>> CHEMICAL_STORAGE_PARTS = new EnumMap<ChemicalStorageVariant, Supplier<Item>>(ChemicalStorageVariant.class);
    private static final Map<ChemicalStorageVariant, Supplier<Item>> CHEMICAL_STORAGE_DISKS = new EnumMap<ChemicalStorageVariant, Supplier<Item>>(ChemicalStorageVariant.class);
    private static final Map<ChemicalStorageVariant, Supplier<Item>> CHEMICAL_STORAGE_BLOCKS = new EnumMap<ChemicalStorageVariant, Supplier<Item>>(ChemicalStorageVariant.class);

    private Items() {
    }

    public static Item getChemicalStoragePart(ChemicalStorageVariant variant) {
        return CHEMICAL_STORAGE_PARTS.get((Object)variant).get();
    }

    public static void setChemicalStoragePart(ChemicalStorageVariant variant, Supplier<Item> supplier) {
        CHEMICAL_STORAGE_PARTS.put(variant, supplier);
    }

    public static Item getChemicalStorageDisk(ChemicalStorageVariant variant) {
        return CHEMICAL_STORAGE_DISKS.get((Object)variant).get();
    }

    public static void setChemicalStorageDisk(ChemicalStorageVariant variant, Supplier<Item> supplier) {
        CHEMICAL_STORAGE_DISKS.put(variant, supplier);
    }

    public static Item getChemicalStorageBlock(ChemicalStorageVariant variant) {
        return CHEMICAL_STORAGE_BLOCKS.get((Object)variant).get();
    }

    public static void setChemicalStorageBlock(ChemicalStorageVariant variant, Supplier<Item> supplier) {
        CHEMICAL_STORAGE_BLOCKS.put(variant, supplier);
    }
}

