/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.common.block.entity;

import cy.jdkdigital.utilitarian.Config;
import cy.jdkdigital.utilitarian.module.UtilityBlockModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class RedstoneClockBlockEntity
extends BlockEntity {
    private int tickCounter = 0;
    private int poweredCounter = 0;
    public int rate = 10;

    public RedstoneClockBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)UtilityBlockModule.REDSTONE_CLOCK_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public static <E extends BlockEntity> void tick(Level level, BlockPos blockPos, BlockState blockState, RedstoneClockBlockEntity blockEntity) {
        block3: {
            block4: {
                if (!(level instanceof ServerLevel) || !((Boolean)blockState.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) break block3;
                if (blockEntity.rate < (Integer)Config.REDSTONE_CLOCK_MIN_FREQUENCY.get()) {
                    blockEntity.rate = (Integer)Config.REDSTONE_CLOCK_MIN_FREQUENCY.get();
                }
                if (((Boolean)blockState.getValue((Property)BlockStateProperties.POWERED)).booleanValue() || ++blockEntity.tickCounter < blockEntity.rate) break block4;
                blockEntity.poweredCounter = 0;
                blockEntity.tickCounter = 0;
                level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(true)));
                for (Direction direction : Direction.values()) {
                    level.updateNeighborsAt(blockPos.relative(direction), blockState.getBlock());
                }
                break block3;
            }
            if (!((Boolean)blockState.getValue((Property)BlockStateProperties.POWERED)).booleanValue() || ++blockEntity.poweredCounter < blockEntity.rate) break block3;
            level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
            for (Direction direction : Direction.values()) {
                level.updateNeighborsAt(blockPos.relative(direction), blockState.getBlock());
            }
        }
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.putInt("rate", this.rate);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.rate = pTag.contains("rate") ? pTag.getInt("rate") : ((Integer)Config.REDSTONE_CLOCK_MIN_FREQUENCY.get()).intValue();
    }
}

