/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.common.block;

import com.mojang.serialization.MapCodec;
import cy.jdkdigital.utilitarian.Config;
import cy.jdkdigital.utilitarian.common.block.entity.RedstoneClockBlockEntity;
import cy.jdkdigital.utilitarian.module.UtilityBlockModule;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class RedstoneClockBlock
extends BaseEntityBlock {
    public static final MapCodec<RedstoneClockBlock> CODEC = RedstoneClockBlock.simpleCodec(RedstoneClockBlock::new);

    public RedstoneClockBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<RedstoneClockBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new RedstoneClockBlockEntity(pPos, pState);
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.isClientSide ? null : RedstoneClockBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)((BlockEntityType)UtilityBlockModule.REDSTONE_CLOCK_BLOCK_ENTITY.get()), RedstoneClockBlockEntity::tick);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{BlockStateProperties.ENABLED, BlockStateProperties.POWERED});
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pOldState.is(pState.getBlock())) {
            this.checkPoweredState(pLevel, pPos, pState, 2);
        }
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        BlockEntity blockEntity;
        if (!pLevel.isClientSide && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof RedstoneClockBlockEntity) {
            RedstoneClockBlockEntity redstoneClockBlockEntity = (RedstoneClockBlockEntity)blockEntity;
            int newValue = redstoneClockBlockEntity.rate + (pPlayer.isShiftKeyDown() ? 10 : 1);
            if (newValue < (Integer)Config.REDSTONE_CLOCK_MIN_FREQUENCY.get() || newValue > 100) {
                newValue = (Integer)Config.REDSTONE_CLOCK_MIN_FREQUENCY.get();
            }
            redstoneClockBlockEntity.rate = newValue;
            pPlayer.displayClientMessage((Component)Component.translatable((String)"block.utilitarian.redstone_clock.message", (Object[])new Object[]{newValue}), true);
        }
        return InteractionResult.SUCCESS;
    }

    public void attack(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        BlockEntity blockEntity;
        if (!pLevel.isClientSide && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof RedstoneClockBlockEntity) {
            RedstoneClockBlockEntity redstoneClockBlockEntity = (RedstoneClockBlockEntity)blockEntity;
            pPlayer.displayClientMessage((Component)Component.translatable((String)"block.utilitarian.redstone_clock.message", (Object[])new Object[]{redstoneClockBlockEntity.rate}), true);
        }
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        BlockState fromState = pLevel.getBlockState(pFromPos);
        if (fromState.is(Blocks.REDSTONE_WIRE) || fromState.hasProperty((Property)BlockStateProperties.POWER)) {
            return;
        }
        this.checkPoweredState(pLevel, pPos, pState, 2);
    }

    private void checkPoweredState(Level pLevel, BlockPos pPos, BlockState pState, int pFlags) {
        boolean noSignal;
        boolean bl = noSignal = !pLevel.hasNeighborSignal(pPos);
        if (noSignal != (Boolean)pState.getValue((Property)BlockStateProperties.ENABLED)) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(noSignal)), pFlags);
        }
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTootipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTootipComponents, pTooltipFlag);
        pTootipComponents.add((Component)Component.translatable((String)"block.utilitarian.redstone_clock.description").withStyle(ChatFormatting.GOLD));
    }

    public boolean isSignalSource(BlockState pState) {
        return true;
    }

    public int getSignal(BlockState pState, BlockGetter pLevel, BlockPos pPos, Direction pDirection) {
        return (Boolean)pState.getValue((Property)BlockStateProperties.ENABLED) != false && (Boolean)pState.getValue((Property)BlockStateProperties.POWERED) != false ? 15 : 0;
    }
}

