/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.camol.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.camol.Camol;
import cy.jdkdigital.camol.common.item.CamoItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class SimpleCamoCraftingRecipe
implements CraftingRecipe {
    private final ItemStack camoItem;

    public SimpleCamoCraftingRecipe(ItemStack camoItem) {
        this.camoItem = camoItem;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public boolean matches(CraftingInput input, Level level) {
        return input.ingredientCount() == 2 && input.items().stream().filter(itemStack -> itemStack.is(this.camoItem.getItem())).toList().size() == 1 && input.items().stream().filter(itemStack -> !itemStack.is(Camol.CRAFTING_BLACKLIST) && itemStack.getItem() instanceof BlockItem).toList().size() == 1;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack camoItem = input.items().stream().filter(itemStack -> !itemStack.is(this.camoItem.getItem())).toList().getFirst();
        Item item = camoItem.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return CamoItem.getCamoItem(blockItem.getBlock().defaultBlockState(), this.camoItem.copy());
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.camoItem.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)Camol.SIMPLE_CAMO_CRAFTING.get();
    }

    public static class Serializer
    implements RecipeSerializer<SimpleCamoCraftingRecipe> {
        private static final MapCodec<SimpleCamoCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ItemStack.CODEC.fieldOf("camo_item").forGetter(recipe -> recipe.camoItem)).apply((Applicative)builder, SimpleCamoCraftingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SimpleCamoCraftingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<SimpleCamoCraftingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SimpleCamoCraftingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static SimpleCamoCraftingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            return new SimpleCamoCraftingRecipe((ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer));
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, SimpleCamoCraftingRecipe recipe) {
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.camoItem);
        }
    }
}

