/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.camol.common.item;

import cy.jdkdigital.camol.Camol;
import cy.jdkdigital.camol.network.SyncChunkCamoData;
import cy.jdkdigital.camol.utils.CamoPosition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.network.PacketDistributor;

public class CamoItem
extends Item {
    public CamoItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        ServerLevel serverLevel;
        Level level = context.getLevel();
        if (level instanceof ServerLevel && !(serverLevel = (ServerLevel)level).getBlockState(context.getClickedPos()).is(Camol.CAMO_BLACKLIST)) {
            BlockState camoState;
            boolean isSolid = this.getDescriptionId().contains("solid");
            String posKey = String.valueOf(context.getClickedPos().asLong());
            LevelChunk chunk = serverLevel.getChunkAt(context.getClickedPos());
            HashMap<String, CamoPosition> camoData = new HashMap<String, CamoPosition>((Map)chunk.getData(Camol.CAMO_BLOCK_MAP));
            if (camoData.containsKey(posKey) && !((CamoPosition)camoData.get(posKey)).state().isAir()) {
                CamoPosition camoPosition = (CamoPosition)camoData.get(posKey);
                Block.popResourceFromFace((Level)serverLevel, (BlockPos)context.getClickedPos(), (Direction)context.getClickedFace(), (ItemStack)CamoItem.getCamoItem(camoPosition.state(), camoPosition.camoType().equals("solid")));
                camoData.put(posKey, new CamoPosition("normal", Blocks.AIR.defaultBlockState()));
            } else if (context.getItemInHand().has(Camol.BLOCK_COMPONENT) && (camoState = (BlockState)context.getItemInHand().get(Camol.BLOCK_COMPONENT)) != null) {
                BlockPlaceContext placeContext = new BlockPlaceContext((Level)serverLevel, context.getPlayer(), context.getHand(), camoState.getBlock().asItem().getDefaultInstance(), new BlockHitResult(context.getClickLocation(), context.getPlayer().getDirection(), context.getClickedPos().relative(context.getPlayer().getDirection()), false));
                BlockState placedState = camoState.getBlock().getStateForPlacement(placeContext);
                if (placedState == null) {
                    placedState = camoState.getBlock().defaultBlockState();
                }
                camoData.put(posKey, new CamoPosition(isSolid ? "solid" : "normal", placedState));
                if (context.getPlayer() == null || !context.getPlayer().hasInfiniteMaterials()) {
                    context.getItemInHand().shrink(1);
                }
            }
            chunk.setData(Camol.CAMO_BLOCK_MAP, camoData);
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(context.getClickedPos()), (CustomPacketPayload)new SyncChunkCamoData(camoData, context.getClickedPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide);
    }

    public Component getName(ItemStack stack) {
        if (stack.has(Camol.BLOCK_COMPONENT)) {
            return Component.translatable((String)(this.getDescriptionId(stack) + ".camo"), (Object[])new Object[]{Component.translatable((String)((BlockState)stack.get(Camol.BLOCK_COMPONENT)).getBlock().getDescriptionId())});
        }
        return super.getName(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".hover" + (!stack.has(Camol.BLOCK_COMPONENT) ? "_empty" : ""))).withStyle(ChatFormatting.GREEN));
        tooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".hover_type")).withStyle(ChatFormatting.GREEN));
    }

    public static ItemStack getCamoItem(BlockState state, boolean isSolid) {
        ItemStack stack = isSolid ? ((Item)Camol.SOLID_CAMO_ITEM.get()).getDefaultInstance() : ((Item)Camol.CAMO_ITEM.get()).getDefaultInstance();
        return CamoItem.getCamoItem(state, stack);
    }

    public static ItemStack getCamoItem(BlockState state, ItemStack stack) {
        stack.set(Camol.BLOCK_COMPONENT, (Object)state.getBlock().defaultBlockState());
        return stack;
    }
}

