/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagradditions.util;

import com.blakebr0.mysticalagradditions.config.ModConfigs;
import com.blakebr0.mysticalagradditions.lib.ModTooltips;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;

public enum EssenceAppleTier {
    INFERIUM(6, 0.3f, List.of(MobEffects.ABSORPTION)),
    PRUDENTIUM(8, 0.4f, List.of(MobEffects.ABSORPTION, MobEffects.MOVEMENT_SPEED)),
    TERTIUM(10, 0.5f, List.of(MobEffects.ABSORPTION, MobEffects.MOVEMENT_SPEED, MobEffects.DAMAGE_RESISTANCE)),
    IMPERIUM(12, 0.6f, List.of(MobEffects.ABSORPTION, MobEffects.MOVEMENT_SPEED, MobEffects.DAMAGE_RESISTANCE, MobEffects.REGENERATION)),
    SUPREMIUM(16, 0.7f, List.of(MobEffects.ABSORPTION, MobEffects.MOVEMENT_SPEED, MobEffects.DAMAGE_RESISTANCE, MobEffects.REGENERATION, MobEffects.DAMAGE_BOOST)),
    INSANIUM(20, 0.8f, List.of(MobEffects.ABSORPTION, MobEffects.MOVEMENT_SPEED, MobEffects.DAMAGE_RESISTANCE, MobEffects.REGENERATION, MobEffects.DAMAGE_BOOST, MobEffects.DIG_SPEED));

    private final Consumer<LivingEntity> onFoodEaten;
    private final List<Component> tooltip;
    private final int hunger;
    private final float saturation;
    private final List<Holder<MobEffect>> effects;

    private EssenceAppleTier(int hunger, float saturation, List<Holder<MobEffect>> effects) {
        this.hunger = hunger;
        this.saturation = saturation;
        this.effects = effects;
        this.onFoodEaten = entity -> {
            for (Holder effect : effects) {
                EssenceAppleTier.addPotionEffect(entity, (Holder<MobEffect>)effect);
            }
        };
        this.tooltip = new ArrayList<Component>();
    }

    public int getHunger() {
        return this.hunger;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public void onFoodEaten(LivingEntity entity) {
        this.onFoodEaten.accept(entity);
    }

    public List<Component> getTooltip() {
        if (this.tooltip.isEmpty()) {
            for (Holder<MobEffect> effect : this.effects) {
                int duration = (Integer)ModConfigs.ESSENCE_APPLE_DURATION.get();
                int minutes = Math.floorDiv(duration, 60);
                String seconds = String.format("%02d", duration % 60);
                this.tooltip.add(ModTooltips.createMobEffectLine(effect, "II", minutes + ":" + seconds));
            }
        }
        return this.tooltip;
    }

    private static void addPotionEffect(LivingEntity entity, Holder<MobEffect> effect) {
        int effectDuration = (Integer)ModConfigs.ESSENCE_APPLE_DURATION.get() * 20;
        MobEffectInstance current = entity.getEffect(effect);
        int duration = current != null ? current.getDuration() : 0;
        entity.addEffect(new MobEffectInstance(effect, duration + effectDuration, 1));
    }
}

