/*
 * Decompiled with CFR 0.152.
 */
package systems.alexander.bellsandwhistles.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HeadlightBlock
extends FaceAttachedHorizontalDirectionalBlock {
    private static final VoxelShape SHAPE = Shapes.join((VoxelShape)Block.box((double)4.5, (double)4.5, (double)13.0, (double)11.5, (double)11.5, (double)16.0), (VoxelShape)Block.box((double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0, (double)16.0), (BooleanOp)BooleanOp.OR);

    public HeadlightBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)FACE, (Comparable)AttachFace.WALL));
    }

    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> codec() {
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, FACE});
    }

    public float getShadeBrightness(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return true;
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        int times = (to.ordinal() - from.get2DDataValue() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.create((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.empty();
        }
        return buffer[0];
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pState.getValue((Property)FACE) == AttachFace.FLOOR) {
            return Shapes.join((VoxelShape)Block.box((double)4.5, (double)0.0, (double)5.0, (double)11.5, (double)3.0, (double)12.0), (VoxelShape)Block.box((double)4.0, (double)0.0, (double)4.5, (double)12.0, (double)2.0, (double)12.5), (BooleanOp)BooleanOp.OR);
        }
        if (pState.getValue((Property)FACE) == AttachFace.CEILING) {
            return Shapes.join((VoxelShape)Block.box((double)4.5, (double)13.0, (double)5.0, (double)11.5, (double)16.0, (double)12.0), (VoxelShape)Block.box((double)4.0, (double)14.0, (double)4.5, (double)12.0, (double)16.0, (double)12.5), (BooleanOp)BooleanOp.OR);
        }
        switch ((Direction)pState.getValue((Property)FACING)) {
            case NORTH: {
                return SHAPE;
            }
            case SOUTH: {
                return HeadlightBlock.rotateShape(Direction.NORTH, Direction.WEST, SHAPE);
            }
            case WEST: {
                return HeadlightBlock.rotateShape(Direction.NORTH, Direction.EAST, SHAPE);
            }
        }
        return HeadlightBlock.rotateShape(Direction.NORTH, Direction.SOUTH, SHAPE);
    }
}

