/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrialforegoingsouls.block.tile;

import com.buuz135.industrialforegoingsouls.block.SoulSurgeBlock;
import com.buuz135.industrialforegoingsouls.block.tile.NetworkBlockEntity;
import com.buuz135.industrialforegoingsouls.block_network.SoulNetwork;
import com.buuz135.industrialforegoingsouls.config.ConfigSoulSurge;
import com.buuz135.industrialforegoingsouls.tag.SoulTags;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.block_network.NetworkManager;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SoulSurgeBlockEntity
extends NetworkBlockEntity<SoulSurgeBlockEntity> {
    @Save
    private int tickingTime;

    public SoulSurgeBlockEntity(BasicTileBlock<SoulSurgeBlockEntity> base, BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(base, blockEntityType, pos, state);
    }

    @NotNull
    public SoulSurgeBlockEntity getSelf() {
        return this;
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, SoulSurgeBlockEntity blockEntity) {
        super.serverTick(level, pos, state, (ActiveTile)blockEntity);
        if (((Boolean)state.getValue((Property)SoulSurgeBlock.ENABLED)).booleanValue()) {
            SoulNetwork network;
            if (NetworkManager.get((Level)this.level).getElement(this.worldPosition) == null) {
                return;
            }
            if (this.tickingTime <= 0 && (network = this.getNetwork()) != null && network.getSoulAmount() > 0) {
                network.useSoul(this.level);
                this.tickingTime = ConfigSoulSurge.SOUL_TIME;
            }
            if (this.tickingTime > 0) {
                if (!level.isLoaded(pos.relative(((Direction)state.getValue((Property)RotatableBlock.FACING_ALL)).getOpposite()))) {
                    return;
                }
                BlockState targetingState = level.getBlockState(pos.relative(((Direction)state.getValue((Property)RotatableBlock.FACING_ALL)).getOpposite()));
                if (!(targetingState.is(Blocks.AIR) || targetingState.is(SoulTags.Blocks.CANT_ACCELERATE) || targetingState.is(SoulTags.Blocks.FORGE_CANT_ACCELERATE))) {
                    BlockEntity targetingTile = level.getBlockEntity(pos.relative(((Direction)state.getValue((Property)RotatableBlock.FACING_ALL)).getOpposite()));
                    if (targetingTile != null) {
                        BlockEntityTicker ticker = targetingState.getTicker(this.level, targetingTile.getType());
                        if (ticker != null) {
                            for (int i = 0; i < ConfigSoulSurge.ACCELERATION_TICK; ++i) {
                                ticker.tick(level, pos.relative(((Direction)state.getValue((Property)RotatableBlock.FACING_ALL)).getOpposite()), targetingState, targetingTile);
                            }
                            --this.tickingTime;
                        }
                    } else if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        if (serverLevel.random.nextDouble() < ConfigSoulSurge.RANDOM_TICK_ACCELERATION_CHANCE) {
                            for (int i = 0; i < ConfigSoulSurge.BLOCK_ACCELERATION_TICK; ++i) {
                                targetingState.randomTick(serverLevel, pos.relative(((Direction)state.getValue((Property)RotatableBlock.FACING_ALL)).getOpposite()), serverLevel.random);
                            }
                        }
                        --this.tickingTime;
                    }
                }
                if (targetingState.is(Blocks.AIR)) {
                    BlockPos posOffset = pos.relative(((Direction)state.getValue((Property)RotatableBlock.FACING_ALL)).getOpposite());
                    VoxelShape box = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0).move((double)posOffset.getX(), (double)posOffset.getY(), (double)posOffset.getZ());
                    List entities = level.getEntitiesOfClass(LivingEntity.class, box.bounds());
                    for (LivingEntity entity : entities) {
                        if (entity.getType().is(SoulTags.Entities.CANT_ACCELERATE)) continue;
                        for (int i = 0; i < ConfigSoulSurge.ENTITIES_ACCELERATION_TICK; ++i) {
                            entity.tick();
                        }
                        --this.tickingTime;
                    }
                }
            }
        }
    }
}

