/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.systems;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.XyCraftTags;
import tv.soaryn.xycraft.core.content.attachments.accessors.CapAccess;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.SidePartBlock;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.content.systems.BlockTickSystemLevelAttachment;
import tv.soaryn.xycraft.core.content.systems.ServerBlockTickSystem;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.network.CBVoidParticlePacket;

public class VoidContainerTickSystem
extends ServerBlockTickSystem<BlockTickSystemLevelAttachment> {
    public int itemAmount = 8;
    public int fluidAmount = 100;
    public int energyAmount = 40;

    public void tickSystem(ServerLevel level, BlockTickSystemLevelAttachment tickData, long currentStep) {
        if (currentStep % tickData.frequency() == 0L) {
            this.itemAmount = (Integer)XyMachines.ServerConfig.VoidContainmentItemAmount.get();
            this.fluidAmount = (Integer)XyMachines.ServerConfig.VoidContainmentFluidAmount.get();
            this.energyAmount = (Integer)XyMachines.ServerConfig.VoidContainmentPowerAmount.get();
        }
    }

    public boolean isValidState(ServerLevel level, BlockState state, BlockPos pos) {
        return state.is(MachinesContent.Block.VoidContainer.block());
    }

    public void clean(ServerLevel level, BlockPos.MutableBlockPos pos) {
        XyBlock.clean((Block)MachinesContent.Block.VoidContainer.block(), (ServerLevel)level, (BlockPos.MutableBlockPos)pos);
        XyMachines.Logger.error("Void Container at block position {} was moved without calling onRemove. Take note of how it may have been moved and please report this on https://github.com/Soaryn/XyCraftTracker/issues", (Object)pos.toShortString());
    }

    protected void tickBlocks(ServerLevel level, BlockTickSystemLevelAttachment tickData, BlockPos.MutableBlockPos pos, BlockState state, long currentStep) {
        BlockEntity blockEntity = level.getBlockEntity((BlockPos)pos);
        if (blockEntity == null) {
            return;
        }
        long currentTime = (Long)blockEntity.getData(CoreAttachments.ProcessTime);
        long newTime = Math.max(currentTime - 1L, 0L);
        if (newTime != currentTime) {
            blockEntity.setData(CoreAttachments.ProcessTime, (Object)newTime);
        }
        if (newTime <= 0L && ((Boolean)blockEntity.getData(CoreAttachments.Void)).booleanValue()) {
            blockEntity.setData(CoreAttachments.Void, (Object)false);
            XyMachines.Network.broadcast((Level)level, (BlockPos)pos, (Packet.ClientBound)new CBVoidParticlePacket((BlockPos)pos));
            blockEntity.setData(CoreAttachments.ProcessTime, (Object)10L);
        }
    }

    protected void tickBatchBlocks(ServerLevel level, BlockTickSystemLevelAttachment tickData, BlockPos.MutableBlockPos pos, BlockState state, long currentStep) {
        FluidStack drained;
        IFluidHandler fluidHandler;
        IItemHandler itemHandler;
        Direction direction = (Direction)state.getValue((Property)CoreStateProperties.StateDirection);
        BlockPos posOfOther = pos.relative(direction);
        BlockState stateOfOther = level.getBlockState(posOfOther);
        if (stateOfOther.is(XyCraftTags.Blocks.VoidContainmentImmune.tag())) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity((BlockPos)pos);
        if (blockEntity == null) {
            return;
        }
        Direction dir = SidePartBlock.directionOf((BlockState)state);
        IEnergyStorage energyHandler = CapAccess.energy((BlockEntity)blockEntity, (Direction)dir);
        if (energyHandler != null && energyHandler.canExtract() && energyHandler.extractEnergy(this.energyAmount, false) > 0) {
            VoidContainerTickSystem.markToVoid(blockEntity);
        }
        if ((itemHandler = CapAccess.item((BlockEntity)blockEntity, (Direction)dir)) != null) {
            int currentAllowedAbsorbed = this.itemAmount;
            for (int slot = 0; slot < itemHandler.getSlots() && currentAllowedAbsorbed > 0; currentAllowedAbsorbed -= itemHandler.extractItem(slot, currentAllowedAbsorbed, false).getCount(), ++slot) {
            }
            if (currentAllowedAbsorbed < this.itemAmount) {
                VoidContainerTickSystem.markToVoid(blockEntity);
            }
        }
        if ((fluidHandler = CapAccess.fluid((BlockEntity)blockEntity, (Direction)dir)) != null && (drained = fluidHandler.drain(this.fluidAmount, IFluidHandler.FluidAction.EXECUTE)).getAmount() > 0) {
            VoidContainerTickSystem.markToVoid(blockEntity);
        }
    }

    private static void markToVoid(BlockEntity blockEntity) {
        blockEntity.setData(CoreAttachments.Void, (Object)true);
    }

    @NotNull
    protected Supplier<AttachmentType<BlockTickSystemLevelAttachment>> getAttachmentType() {
        return MachinesAttachments.System.VoidSystemData;
    }
}

