/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.systems;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.container.item.ItemContainer;
import tv.soaryn.xycraft.core.container.item.SimpleItemContainer;
import tv.soaryn.xycraft.core.content.XyCraftTags;
import tv.soaryn.xycraft.core.content.attachments.accessors.CapAccess;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.content.systems.BlockTickSystemLevelAttachment;
import tv.soaryn.xycraft.core.content.systems.ServerBlockTickSystem;
import tv.soaryn.xycraft.core.utils.BitFlagUtils;
import tv.soaryn.xycraft.core.utils.FakePlayerUtils;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.attachments.FabricatorAttachment;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

public class FabricatorTickSystem
extends ServerBlockTickSystem<BlockTickSystemLevelAttachment> {
    public boolean isValidState(ServerLevel level, BlockState state, BlockPos pos) {
        return state.is(MachinesContent.Block.Fabricator.block());
    }

    public void clean(ServerLevel level, BlockPos.MutableBlockPos pos) {
        XyBlock.clean((Block)MachinesContent.Block.Fabricator.block(), (ServerLevel)level, (BlockPos.MutableBlockPos)pos);
        XyMachines.Logger.error("Fabricator at block position {} was moved without calling onRemove. Take note of how it may have been moved and please report this on https://github.com/Soaryn/XyCraftTracker/issues", (Object)pos.toShortString());
    }

    protected void tickBlocks(ServerLevel level, BlockTickSystemLevelAttachment tickData, BlockPos.MutableBlockPos pos, BlockState state, long currentStep) {
        boolean hasSignal;
        super.tickBlocks(level, tickData, pos, state, currentStep);
        BlockEntity blockEntity = level.getBlockEntity((BlockPos)pos);
        if (blockEntity == null) {
            return;
        }
        FabricatorAttachment data = (FabricatorAttachment)blockEntity.getData(MachinesAttachments.Block.FabricatorData);
        int mode = data.MenuData.get(1);
        if (mode == 0) {
            return;
        }
        boolean canCraftNow = data.canCraft();
        boolean prevState = data.prevRedstoneState();
        boolean bl = hasSignal = (tickData.frequency() + pos.asLong()) % 2L == 0L ? level.hasNeighborSignal((BlockPos)pos) : prevState;
        if (prevState != hasSignal) {
            data.setPrevRedstoneState(hasSignal);
        }
        switch (mode) {
            case 1: {
                if (hasSignal && !canCraftNow) {
                    data.setCanCraft(true);
                    level.markAndNotifyBlock((BlockPos)pos, level.getChunkAt((BlockPos)pos), state, state, 3, 512);
                    break;
                }
                if (hasSignal || !canCraftNow) break;
                data.setCanCraft(false);
                level.markAndNotifyBlock((BlockPos)pos, level.getChunkAt((BlockPos)pos), state, state, 3, 512);
                break;
            }
            case 2: {
                long processingTime = (Long)blockEntity.getData(CoreAttachments.ProcessTime);
                if (processingTime > 0L) {
                    blockEntity.setData(CoreAttachments.ProcessTime, (Object)(processingTime - 1L));
                }
                if (processingTime == 0L && canCraftNow) {
                    data.setCanCraft(false);
                    level.markAndNotifyBlock((BlockPos)pos, level.getChunkAt((BlockPos)pos), state, state, 3, 512);
                    return;
                }
                if (prevState == hasSignal) {
                    return;
                }
                if (canCraftNow || !hasSignal || processingTime != 0L) break;
                blockEntity.setData(CoreAttachments.ProcessTime, (Object)4L);
                if (!this.tryCraft(level, data, state, blockEntity, (BlockPos)pos)) {
                    return;
                }
                data.setCanCraft(true);
                level.markAndNotifyBlock((BlockPos)pos, level.getChunkAt((BlockPos)pos), state, state, 3, 512);
                break;
            }
        }
    }

    protected void tickBatchBlocks(ServerLevel level, BlockTickSystemLevelAttachment tickData, BlockPos.MutableBlockPos pos, BlockState state, long currentStep) {
        BlockEntity blockEntity = level.getBlockEntity((BlockPos)pos);
        if (blockEntity == null) {
            return;
        }
        FabricatorAttachment data = (FabricatorAttachment)blockEntity.getData(MachinesAttachments.Block.FabricatorData);
        data.invalidateRecipeCache();
        int mode = data.MenuData.get(1);
        boolean canCraftNow = data.canCraft();
        if (!canCraftNow || mode == 2) {
            return;
        }
        this.tryCraft(level, data, state, blockEntity, (BlockPos)pos);
    }

    private boolean tryCraft(ServerLevel level, FabricatorAttachment data, BlockState state, BlockEntity blockEntity, BlockPos pos) {
        int i;
        int ghostSlot;
        if (data.RecipeCache.isEmpty()) {
            return false;
        }
        RecipeHolder<CraftingRecipe> recipe = data.RecipeCache.get();
        SimpleItemContainer ghostCopy = new SimpleItemContainer(data.Ghost.size());
        for (int craftingSlot = 0; craftingSlot < 9; ++craftingSlot) {
            ghostCopy.set(craftingSlot, data.Ghost.get(craftingSlot).copy());
        }
        SimpleItemContainer sandboxCrafting = new SimpleItemContainer(data.Ghost.size());
        SimpleItemContainer finalCrafting = new SimpleItemContainer(data.Ghost.size());
        int strictFlag = data.MenuData.get(0);
        ArrayList<IItemHandler> itemHandlers = new ArrayList<IItemHandler>();
        itemHandlers.add(data.ItemHandler);
        for (Direction direction : Direction.values()) {
            IItemHandler itemHandler;
            if (state.getValue((Property)CoreStateProperties.StateDirection) == direction || level.getBlockState(pos.relative(direction)).is(XyCraftTags.Blocks.FabricatorIgnore.tag()) || (itemHandler = CapAccess.item((BlockEntity)blockEntity, (Direction)direction)) == null) continue;
            itemHandlers.add(itemHandler);
        }
        if (data.Inventory.isEmpty() && itemHandlers.size() == 1) {
            return false;
        }
        ArrayList<CraftingIngredient> listOfIngredients = new ArrayList<CraftingIngredient>(9);
        block2: for (ghostSlot = 0; ghostSlot < 9; ++ghostSlot) {
            if (!BitFlagUtils.getFlag((int)strictFlag, (int)((byte)ghostSlot)) || data.Ghost.get(ghostSlot).isEmpty()) continue;
            FabricatorTickSystem.resetSandbox((ItemContainer)sandboxCrafting, (ItemContainer)ghostCopy);
            ItemStack specificItemStack = sandboxCrafting.get(ghostSlot);
            for (IItemHandler handler : itemHandlers) {
                if (!this.findInput((Level)level, (CraftingRecipe)recipe.value(), specificItemStack, (ItemContainer)sandboxCrafting, (ItemContainer)finalCrafting, listOfIngredients, handler, ghostSlot, true)) continue;
                continue block2;
            }
        }
        block4: for (ghostSlot = 0; ghostSlot < 9; ++ghostSlot) {
            if (BitFlagUtils.getFlag((int)strictFlag, (int)((byte)ghostSlot)) || data.Ghost.get(ghostSlot).isEmpty()) continue;
            FabricatorTickSystem.resetSandbox((ItemContainer)sandboxCrafting, (ItemContainer)ghostCopy);
            ItemStack specificItemStack = sandboxCrafting.get(ghostSlot);
            for (IItemHandler handler : itemHandlers) {
                if (!this.findInput((Level)level, (CraftingRecipe)recipe.value(), specificItemStack, (ItemContainer)sandboxCrafting, (ItemContainer)finalCrafting, listOfIngredients, handler, ghostSlot, false)) continue;
                continue block4;
            }
        }
        int finalIngredientCount = 0;
        int intendedIngredientCount = 0;
        for (i = 0; i < finalCrafting.size(); ++i) {
            if (finalCrafting.get(i).isEmpty()) continue;
            ++finalIngredientCount;
        }
        for (i = 0; i < data.Ghost.size() - 1; ++i) {
            if (data.Ghost.get(i).isEmpty()) continue;
            ++intendedIngredientCount;
        }
        if (intendedIngredientCount != finalIngredientCount) {
            return false;
        }
        CraftingInput input = CraftingInput.ofPositioned((int)3, (int)3, (List)finalCrafting.copyToList()).input();
        return ((CraftingRecipe)recipe.value()).matches((RecipeInput)input, (Level)level) && this.craft(level, data, (CraftingRecipe)recipe.value(), (ItemContainer)finalCrafting, input, listOfIngredients);
    }

    private static void resetSandbox(ItemContainer destination, ItemContainer src) {
        for (int craftingSlot = 0; craftingSlot < 9; ++craftingSlot) {
            destination.set(craftingSlot, src.get(craftingSlot));
        }
    }

    @NotNull
    protected Supplier<AttachmentType<BlockTickSystemLevelAttachment>> getAttachmentType() {
        return MachinesAttachments.System.FabricatorSystemData;
    }

    private boolean findInput(Level level, CraftingRecipe recipe, ItemStack specificStack, ItemContainer sandbox, ItemContainer finalCrafting, List<CraftingIngredient> currentIngredients, IItemHandler handler, int ghostSlot, boolean isStrict) {
        for (int inventorySlot = handler.getSlots() - 1; inventorySlot >= 0; --inventorySlot) {
            int amountNeededFromSlot = 1;
            for (CraftingIngredient existing : currentIngredients) {
                if (existing.slot != inventorySlot || handler != existing.handler) continue;
                ++amountNeededFromSlot;
            }
            ItemStack inputStack = handler.extractItem(inventorySlot, amountNeededFromSlot, true).copy();
            if (inputStack.isEmpty() || inputStack.getCount() < amountNeededFromSlot || inputStack.hasCraftingRemainingItem() && !ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)inputStack.getCraftingRemainingItem(), (boolean)true).isEmpty()) continue;
            inputStack.setCount(1);
            if (isStrict && !ItemStack.matches((ItemStack)specificStack, (ItemStack)inputStack)) continue;
            sandbox.set(ghostSlot, inputStack);
            CraftingInput craftInput = CraftingInput.ofPositioned((int)3, (int)3, (List)sandbox.copyToList()).input();
            if (!recipe.matches((RecipeInput)craftInput, level) || ItemStack.matches((ItemStack)recipe.assemble((RecipeInput)craftInput, (HolderLookup.Provider)level.registryAccess()), (ItemStack)inputStack) && !isStrict) continue;
            currentIngredients.add(new CraftingIngredient(handler, inputStack, inventorySlot));
            finalCrafting.set(ghostSlot, inputStack);
            return true;
        }
        return false;
    }

    private boolean craft(ServerLevel level, FabricatorAttachment data, CraftingRecipe recipe, ItemContainer matrix, CraftingInput input, ArrayList<CraftingIngredient> listOfIngredients) {
        int o;
        int n;
        ArrayList<IItemHandler> usedHandlers = new ArrayList<IItemHandler>();
        ArrayList<ItemStack> remainingItemList = new ArrayList<ItemStack>();
        for (CraftingIngredient ingredient : listOfIngredients) {
            if (!usedHandlers.contains(ingredient.handler)) {
                usedHandlers.add(ingredient.handler);
            }
            if (!ingredient.inputStack.hasCraftingRemainingItem()) continue;
            remainingItemList.add(ingredient.inputStack.getCraftingRemainingItem());
        }
        ItemStack output = recipe.assemble((RecipeInput)input, (HolderLookup.Provider)level.registryAccess());
        SimpleItemContainer sandboxInventory = new SimpleItemContainer(9);
        for (int i = 0; i < sandboxInventory.size(); ++i) {
            sandboxInventory.set(i, data.Storage.get(i).copy());
        }
        ArrayList<ItemStack> copyOfRemainders = new ArrayList<ItemStack>((Collection<ItemStack>)recipe.getRemainingItems((RecipeInput)input));
        copyOfRemainders.removeIf(ItemStack::isEmpty);
        List<ItemStack> extraRemainders = remainingItemList.stream().filter(copyOfRemainders::contains).toList();
        IItemHandlerModifiable sandboxHandle = sandboxInventory.asHandler();
        Integer[] internalItemsNeeded = (Integer[])listOfIngredients.stream().filter(craftingIngredient -> craftingIngredient.handler() == data.ItemHandler).map(CraftingIngredient::slot).toArray(Integer[]::new);
        Object object = internalItemsNeeded;
        int n2 = ((Integer[])object).length;
        for (n = 0; n < n2; ++n) {
            o = object[n];
            sandboxHandle.extractItem(o, 1, false);
        }
        object = internalItemsNeeded;
        n2 = ((Integer[])object).length;
        for (n = 0; n < n2; ++n) {
            IItemHandler inventoryHandler = data.ItemHandler;
            o = object[n];
            ItemStack testStack = inventoryHandler.extractItem(o, 1, true);
            if (!testStack.hasCraftingRemainingItem() || ItemHandlerHelper.insertItemStacked((IItemHandler)sandboxHandle, (ItemStack)testStack.getCraftingRemainingItem(), (boolean)false).isEmpty()) continue;
            return false;
        }
        for (ItemStack remainder : extraRemainders) {
            if (ItemHandlerHelper.insertItemStacked((IItemHandler)sandboxHandle, (ItemStack)remainder.copy(), (boolean)false).isEmpty()) continue;
            return false;
        }
        if (!ItemHandlerHelper.insertItemStacked((IItemHandler)sandboxHandle, (ItemStack)output.copy(), (boolean)false).isEmpty()) {
            return false;
        }
        output.onCraftedBySystem((Level)level);
        PlayerEvent.ItemCraftedEvent eventStruct = new PlayerEvent.ItemCraftedEvent(FakePlayerUtils.getFakePlayer((ServerLevel)level, (UUID)data.playerId()), output, matrix.asVanillaContainer());
        NeoForge.EVENT_BUS.post((Event)eventStruct);
        output.onCraftedBySystem((Level)level);
        for (CraftingIngredient ingredient : listOfIngredients) {
            ItemStack extracted = ingredient.handler.extractItem(ingredient.slot, 1, false);
            if (!extracted.hasCraftingRemainingItem()) continue;
            ItemHandlerHelper.insertItemStacked((IItemHandler)ingredient.handler, (ItemStack)extracted.getCraftingRemainingItem(), (boolean)false);
        }
        ItemHandlerHelper.insertItemStacked((IItemHandler)data.ItemHandler, (ItemStack)output, (boolean)false);
        for (ItemStack extraRemainder : extraRemainders) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)data.ItemHandler, (ItemStack)extraRemainder, (boolean)false);
        }
        return true;
    }

    private record CraftingIngredient(IItemHandler handler, ItemStack inputStack, int slot) {
    }
}

