/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.recipes.producers.squasher;

import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.IStage;
import tv.soaryn.xycraft.core.content.recipe.IRecipeBuilder;
import tv.soaryn.xycraft.machines.content.recipes.producers.squasher.SquasherRecipe;

public class SquasherRecipeBuilder
implements IRecipeBuilder.WithItem.Input<SquasherRecipeBuilder, SquasherRecipe>,
IRecipeBuilder.WithItem.Output<SquasherRecipeBuilder, SquasherRecipe>,
IRecipeBuilder.WithStage<SquasherRecipeBuilder, SquasherRecipe> {
    private SizedIngredient _ingredient;
    private ItemStack _output = ItemStack.EMPTY;
    private long _ticks = 100L;
    private Optional<IStage> _requiredStage = Optional.empty();

    public static SquasherRecipeBuilder create() {
        return new SquasherRecipeBuilder();
    }

    public SquasherRecipeBuilder input(SizedIngredient input) {
        this._ingredient = input;
        return this;
    }

    public SquasherRecipeBuilder output(ItemStack output) {
        this._output = output;
        return this;
    }

    @NotNull
    public SquasherRecipeBuilder ticks(long ticks) {
        this._ticks = ticks;
        return this;
    }

    @NotNull
    public SquasherRecipe makeRecipe() {
        return new SquasherRecipe(this._ingredient, this._output, this._ticks, this._requiredStage);
    }

    public void ensureValid(String id) {
        if (this._ingredient == null) {
            throw new RuntimeException("Ingredient is null in Squasher recipe - " + id);
        }
        if (this._output.isEmpty()) {
            throw new RuntimeException("No output in Squasher recipe - " + id);
        }
        if (this._ticks <= 0L) {
            throw new RuntimeException("No ticks in Squasher recipe - " + id);
        }
    }

    @NotNull
    public SquasherRecipeBuilder requires(IStage stage) {
        this._requiredStage = Optional.of(stage);
        return this;
    }
}

