/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.recipes.producers.crusher;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.IStage;
import tv.soaryn.xycraft.core.content.recipe.ChanceOutput;
import tv.soaryn.xycraft.core.content.recipe.IRecipeBuilder;
import tv.soaryn.xycraft.machines.content.recipes.producers.crusher.CrusherRecipe;

public class CrusherRecipeBuilder
implements IRecipeBuilder.WithItem.Input<CrusherRecipeBuilder, CrusherRecipe> {
    private SizedIngredient _ingredient;
    private final ArrayList<ChanceOutput> _outputs = new ArrayList();
    private long _ticks = 100L;
    private Optional<IStage> _requiredStage = Optional.empty();

    public static CrusherRecipeBuilder create() {
        return new CrusherRecipeBuilder();
    }

    public CrusherRecipeBuilder requires(Holder<IStage> stage) {
        this._requiredStage = Optional.of((IStage)stage.value());
        return this;
    }

    public CrusherRecipeBuilder requires(IStage stage) {
        this._requiredStage = Optional.of(stage);
        return this;
    }

    public CrusherRecipeBuilder input(SizedIngredient input) {
        this._ingredient = input;
        return this;
    }

    public CrusherRecipeBuilder output(ItemStack stack) {
        return this.output(stack, 100);
    }

    public CrusherRecipeBuilder output(ItemStack stack, int chance) {
        this._outputs.add(new ChanceOutput(stack, (byte)chance));
        return this;
    }

    public CrusherRecipeBuilder output(ItemLike item) {
        return this.output(item, 100);
    }

    public CrusherRecipeBuilder output(ItemLike item, int chance) {
        this._outputs.add(new ChanceOutput(new ItemStack(item), (byte)chance));
        return this;
    }

    @NotNull
    public CrusherRecipeBuilder ticks(long ticks) {
        this._ticks = ticks;
        return this;
    }

    @NotNull
    public CrusherRecipe makeRecipe() {
        return new CrusherRecipe(this._ingredient, this._outputs, this._ticks, this._requiredStage);
    }

    public void ensureValid(String id) {
        if (this._ingredient == null) {
            throw new RuntimeException("Ingredient is null in Crusher recipe - " + id);
        }
        if (this._outputs.isEmpty()) {
            throw new RuntimeException("No outputs in Crusher recipe - " + id);
        }
        if (this._outputs.size() > 9) {
            throw new RuntimeException("Too many outputs in Crusher recipe - " + id);
        }
    }
}

