/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.multiblock.tank;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import tv.soaryn.xycraft.core.content.XyCraftTags;
import tv.soaryn.xycraft.core.utils.multiblock.BlockUsage;
import tv.soaryn.xycraft.core.utils.multiblock.FormationRules;
import tv.soaryn.xycraft.machines.XyMachines;

class MultiTankFormationRules
implements FormationRules {
    MultiTankFormationRules() {
    }

    public int getMaxSize(Direction.Axis axis) {
        return (Integer)XyMachines.ServerConfig.TankSizeLimit.get();
    }

    public boolean isValid(BlockGetter level, BlockPos pos, BlockUsage type) {
        BlockState state = level.getBlockState(pos);
        if (type == BlockUsage.WALL) {
            if (state.is(XyCraftTags.Blocks.TankMultiBlockValidFace.tag())) {
                return true;
            }
            if (state.is(XyCraftTags.Blocks.TankMultiBlockInvalidFace.tag())) {
                return false;
            }
        } else if (type == BlockUsage.EDGE) {
            if (state.is(XyCraftTags.Blocks.TankMultiBlockValidFrame.tag())) {
                return true;
            }
            if (state.is(XyCraftTags.Blocks.TankMultiBlockInvalidFrame.tag())) {
                return false;
            }
        } else if (type == BlockUsage.INNER) {
            if (state.is(XyCraftTags.Blocks.TankMultiBlockValidEmpty.tag())) {
                return true;
            }
            if (state.is(XyCraftTags.Blocks.TankMultiBlockInvalidEmpty.tag())) {
                return false;
            }
            if (FormationRules.isBlockGenerallyAccepted((BlockGetter)level, (BlockPos)pos, (BlockUsage)type)) {
                return true;
            }
            return state.isAir();
        }
        return FormationRules.isBlockGenerallyAccepted((BlockGetter)level, (BlockPos)pos, (BlockUsage)type);
    }
}

