/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.multiblock.producers;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.container.SimpleResourceFluidContainer;
import tv.soaryn.xycraft.core.container.SimpleResourceItemContainer;
import tv.soaryn.xycraft.core.container.resource.IResourceContainer;
import tv.soaryn.xycraft.core.container.resource.MutableResourceStack;
import tv.soaryn.xycraft.core.utils.handlers.HandlerIOBehavior;
import tv.soaryn.xycraft.core.utils.protocontainer.FluidResource;
import tv.soaryn.xycraft.core.utils.protocontainer.IResourceHandler;
import tv.soaryn.xycraft.core.utils.protocontainer.ItemResource;
import tv.soaryn.xycraft.core.utils.resources.FluidUtils;
import tv.soaryn.xycraft.machines.content.multiblock.producers.ProcessorFactories;

public class BlenderInventory {
    public static final Codec<BlenderInventory> CODEC = ProcessorFactories.Hybrid.producerCodec(BlenderInventory::new, data -> data._items, data -> data._fluids, data -> data._fluids.getCapacity(), data -> Optional.ofNullable(data.SelectedRecipe));
    @Nullable
    public ResourceLocation SelectedRecipe;
    private final SimpleResourceItemContainer _items;
    private final SimpleResourceFluidContainer _fluids;
    public final transient IResourceContainer<ItemResource> ItemInputA;
    public final transient IResourceContainer<ItemResource> ItemInputB;
    public final transient IResourceContainer<ItemResource> ItemOutput;
    public final transient IResourceContainer<FluidResource> FluidInputA;
    public final transient IResourceContainer<FluidResource> FluidInputB;
    public final transient IResourceContainer<FluidResource> FluidOutput;
    public final transient IResourceHandler<ItemResource> ItemInputAHandler;
    public final transient IResourceHandler<ItemResource> ItemInputBHandler;
    public final transient IResourceHandler<ItemResource> ItemOutputHandler;
    public final transient IResourceHandler<FluidResource> FluidInputAHandler;
    public final transient IResourceHandler<FluidResource> FluidInputBHandler;
    public final transient IResourceHandler<FluidResource> FluidOutputHandler;

    public static BlenderInventory create() {
        return new BlenderInventory((NonNullList<MutableResourceStack<ItemResource>>)MutableResourceStack.Empty.ITEM.nonNullListOfSize(11), (NonNullList<MutableResourceStack<FluidResource>>)MutableResourceStack.Empty.FLUID.nonNullListOfSize(3), FluidUtils.inBuckets((int)4), Optional.empty());
    }

    private BlenderInventory(NonNullList<MutableResourceStack<ItemResource>> items, NonNullList<MutableResourceStack<FluidResource>> fluids, int capacity, Optional<ResourceLocation> recipeId) {
        this._items = SimpleResourceItemContainer.from(items, this::onChanged);
        this._fluids = SimpleResourceFluidContainer.from(fluids, (int)capacity, this::onChanged);
        this.SelectedRecipe = recipeId.orElse(null);
        this.ItemInputA = this._items.slice(0, 1);
        this.ItemInputB = this._items.slice(1, 1);
        this.ItemOutput = this._items.slice(2, 9);
        this.FluidInputA = this._fluids.slice(0, 1);
        this.FluidInputB = this._fluids.slice(1, 1);
        this.FluidOutput = this._fluids.slice(2, 1);
        this.ItemInputAHandler = this.ItemInputA.asHandler(HandlerIOBehavior.INSERT_ONLY);
        this.ItemInputBHandler = this.ItemInputB.asHandler(HandlerIOBehavior.INSERT_ONLY);
        this.ItemOutputHandler = this.ItemOutput.asHandler(HandlerIOBehavior.EXTRACT_ONLY);
        this.FluidInputAHandler = this.FluidInputA.asHandler(HandlerIOBehavior.INSERT_ONLY);
        this.FluidInputBHandler = this.FluidInputB.asHandler(HandlerIOBehavior.INSERT_ONLY);
        this.FluidOutputHandler = this.FluidOutput.asHandler(HandlerIOBehavior.EXTRACT_ONLY);
    }

    public void onChanged() {
    }
}

