/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.items.modular.proto.modules.armor;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import tv.soaryn.xycraft.api.content.capabilities.ITotemDeathHandler;
import tv.soaryn.xycraft.api.content.capabilities.modular.IModule;
import tv.soaryn.xycraft.api.content.capabilities.modular.IModuleContainer;
import tv.soaryn.xycraft.api.content.capabilities.modular.ModuleType;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.machines.content.items.modular.proto.modules.MachinesModules;
import tv.soaryn.xycraft.machines.content.items.modular.proto.modules.armor.IArmorModule;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.GAME)
public record TotemModule() implements IArmorModule
{
    public ModuleType getModuleType() {
        return ModuleType.Legendary;
    }

    @Override
    public EquipmentSlotGroup getValidSlots() {
        return EquipmentSlotGroup.CHEST;
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        if (event.isCanceled() || event.getSource().is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        IModuleContainer moduleStorage = (IModuleContainer)player.getItemBySlot(EquipmentSlot.CHEST).getCapability(CoreCapabilities.ModuleContainer.ITEM);
        if (moduleStorage == null) {
            return;
        }
        boolean anyMatched = moduleStorage.getInstalledModules().stream().anyMatch(moduleRecord -> ((IModule)MachinesModules.TotemConsumer.value()).equals((Object)moduleRecord.module()));
        if (!anyMatched) {
            return;
        }
        for (ItemStack stack : player.getInventory().items) {
            ITotemDeathHandler totemDeathHandler = (ITotemDeathHandler)stack.getCapability(CoreCapabilities.TotemConsumable.ITEM);
            if (totemDeathHandler == null || !totemDeathHandler.consume(player)) continue;
            event.setCanceled(true);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)player;
                serverplayer.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()), 1);
                CriteriaTriggers.USED_TOTEM.trigger(serverplayer, stack);
            }
            return;
        }
    }
}

