/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.SetBlockCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Clearable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.joml.Random;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.commands.ICommand;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.world.content.registries.WorldContent;

public record BuildCommand() implements ICommand
{
    private static final BlockInput HOLLOW_CORE = new BlockInput(Blocks.AIR.defaultBlockState(), Collections.emptySet(), null);
    private static final Dynamic2CommandExceptionType ERROR_AREA_TOO_LARGE = new Dynamic2CommandExceptionType((bound, provided) -> Component.translatable((String)"commands.xycraft.buildtank.toobig", (Object[])new Object[]{bound, provided}));
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.xycraft.buildtank.failed"));

    public static ICommand register(RegisterCommandsEvent event) {
        return new BuildCommand().register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getCommandSelection(), event.getBuildContext());
    }

    public ICommand register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment, CommandBuildContext context) {
        String KEY_FRAME = "frame";
        String KEY_FACE = "face";
        String KEY_ORIGIN = "origin";
        String KEY_SIZE = "size";
        Random rand = new Random();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"xycraft").requires(ICommand::gamemaster)).then(Commands.literal((String)"build").then(Commands.literal((String)"tank").then(Commands.argument((String)KEY_ORIGIN, (ArgumentType)BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument((String)KEY_SIZE, (ArgumentType)IntegerArgumentType.integer((int)3, (int)33)).executes(commandStack -> {
            BlockPos origin = BlockPosArgument.getLoadedBlockPos((CommandContext)commandStack, (String)KEY_ORIGIN);
            int i = IntegerArgumentType.getInteger((CommandContext)commandStack, (String)KEY_SIZE) - 1;
            if ((Integer)XyMachines.ServerConfig.TankSizeLimit.get() < i) {
                throw ERROR_AREA_TOO_LARGE.create(XyMachines.ServerConfig.TankSizeLimit.get(), (Object)i);
            }
            BlockPos to = origin.offset(i, i, i);
            BlockInput defaultFace = new BlockInput(WorldContent.Block.GlassViewerGlowing.block().defaultBlockState(), Collections.emptySet(), null);
            BlockInput defaultFrame = new BlockInput(((BlockContent[])WorldContent.Block.AluminumBricksCloud.values().toArray(BlockContent[]::new))[rand.nextInt(WorldContent.Block.AluminumBricksCloud.size())].block().defaultBlockState(), Collections.emptySet(), null);
            return BuildCommand.fillBlocks((CommandSourceStack)commandStack.getSource(), BoundingBox.fromCorners((Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)commandStack, (String)KEY_ORIGIN), (Vec3i)to), defaultFrame, defaultFace);
        })).then(((RequiredArgumentBuilder)Commands.argument((String)KEY_FRAME, (ArgumentType)BlockStateArgument.block((CommandBuildContext)context)).executes(commandStack -> {
            BlockPos origin = BlockPosArgument.getLoadedBlockPos((CommandContext)commandStack, (String)KEY_ORIGIN);
            int i = IntegerArgumentType.getInteger((CommandContext)commandStack, (String)KEY_SIZE) - 1;
            BlockPos to = origin.offset(i, i, i);
            BlockInput defaultFace = new BlockInput(WorldContent.Block.GlassViewerGlowing.block().defaultBlockState(), Collections.emptySet(), null);
            BlockInput input = BlockStateArgument.getBlock((CommandContext)commandStack, (String)KEY_FRAME);
            return BuildCommand.fillBlocks((CommandSourceStack)commandStack.getSource(), BoundingBox.fromCorners((Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)commandStack, (String)KEY_ORIGIN), (Vec3i)to), input, defaultFace);
        })).then(Commands.argument((String)KEY_FACE, (ArgumentType)BlockStateArgument.block((CommandBuildContext)context)).executes(commandStack -> {
            BlockPos origin = BlockPosArgument.getLoadedBlockPos((CommandContext)commandStack, (String)KEY_ORIGIN);
            int i = IntegerArgumentType.getInteger((CommandContext)commandStack, (String)KEY_SIZE) - 1;
            BlockPos to = origin.offset(i, i, i);
            return BuildCommand.fillBlocks((CommandSourceStack)commandStack.getSource(), BoundingBox.fromCorners((Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)commandStack, (String)KEY_ORIGIN), (Vec3i)to), BlockStateArgument.getBlock((CommandContext)commandStack, (String)KEY_FRAME), BlockStateArgument.getBlock((CommandContext)commandStack, (String)KEY_FACE));
        }))))))));
        return this;
    }

    private static int fillBlocks(CommandSourceStack commandStack, BoundingBox boundingBox, BlockInput frame, BlockInput face) throws CommandSyntaxException {
        int maxCount;
        int volume = boundingBox.getXSpan() * boundingBox.getYSpan() * boundingBox.getZSpan();
        if (volume > (maxCount = 35937)) {
            throw ERROR_AREA_TOO_LARGE.create((Object)maxCount, (Object)volume);
        }
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        ServerLevel serverlevel = commandStack.getLevel();
        for (BlockPos blockpos : BlockPos.betweenClosed((int)boundingBox.minX(), (int)boundingBox.minY(), (int)boundingBox.minZ(), (int)boundingBox.maxX(), (int)boundingBox.maxY(), (int)boundingBox.maxZ())) {
            BlockEntity blockentity;
            BlockInput blockInputFrame = Mode.OUTLINE.filter.filter(boundingBox, blockpos, frame, serverlevel);
            BlockInput blockInputFace = Mode.HOLLOW.filter.filter(boundingBox, blockpos, face, serverlevel);
            if (blockInputFrame != null) {
                blockentity = serverlevel.getBlockEntity(blockpos);
                Clearable.tryClear((Object)blockentity);
                if (!blockInputFrame.place(serverlevel, blockpos, 2)) continue;
                list.add(blockpos.immutable());
                continue;
            }
            if (blockInputFace == null) continue;
            blockentity = serverlevel.getBlockEntity(blockpos);
            Clearable.tryClear((Object)blockentity);
            if (!blockInputFace.place(serverlevel, blockpos, 2)) continue;
            list.add(blockpos.immutable());
        }
        int count = list.size();
        if (count == 0) {
            throw ERROR_FAILED.create();
        }
        for (BlockPos updateList : list) {
            Block block = serverlevel.getBlockState(updateList).getBlock();
            serverlevel.blockUpdated(updateList, block);
        }
        commandStack.sendSuccess(() -> Component.translatable((String)"commands.fill.success", (Object[])new Object[]{count}), true);
        return count;
    }

    static enum Mode {
        OUTLINE((boundingBox, pos, input, level) -> {
            if (pos.getX() == boundingBox.minX() && pos.getY() == boundingBox.minY()) {
                return input;
            }
            if (pos.getX() == boundingBox.minX() && pos.getY() == boundingBox.maxY()) {
                return input;
            }
            if (pos.getX() == boundingBox.maxX() && pos.getY() == boundingBox.minY()) {
                return input;
            }
            if (pos.getX() == boundingBox.maxX() && pos.getY() == boundingBox.maxY()) {
                return input;
            }
            if (pos.getX() == boundingBox.minX() && pos.getZ() == boundingBox.minZ()) {
                return input;
            }
            if (pos.getX() == boundingBox.maxX() && pos.getZ() == boundingBox.minZ()) {
                return input;
            }
            if (pos.getX() == boundingBox.minX() && pos.getZ() == boundingBox.maxZ()) {
                return input;
            }
            if (pos.getX() == boundingBox.maxX() && pos.getZ() == boundingBox.maxZ()) {
                return input;
            }
            if (pos.getZ() == boundingBox.minZ() && pos.getY() == boundingBox.minY()) {
                return input;
            }
            if (pos.getZ() == boundingBox.minZ() && pos.getY() == boundingBox.maxY()) {
                return input;
            }
            if (pos.getZ() == boundingBox.maxZ() && pos.getY() == boundingBox.minY()) {
                return input;
            }
            if (pos.getZ() == boundingBox.maxZ() && pos.getY() == boundingBox.maxY()) {
                return input;
            }
            return null;
        }),
        HOLLOW((boundingBox, pos, input, level) -> pos.getX() != boundingBox.minX() && pos.getX() != boundingBox.maxX() && pos.getY() != boundingBox.minY() && pos.getY() != boundingBox.maxY() && pos.getZ() != boundingBox.minZ() && pos.getZ() != boundingBox.maxZ() ? HOLLOW_CORE : input);

        public final SetBlockCommand.Filter filter;

        private Mode(SetBlockCommand.Filter filter) {
            this.filter = filter;
        }
    }
}

