/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.balloonstake;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.NeoForgeMod;
import tv.soaryn.xycraft.core.content.blocks.XyBlockEntity;
import tv.soaryn.xycraft.machines.content.attachments.BalloonStakeAttachment;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.content.systems.BalloonStakeTickSystem;

public class BalloonStakeBlockEntity
extends XyBlockEntity {
    public BalloonStakeBlockEntity(BlockPos pos, BlockState state) {
        super(MachinesContent.Block.Stake.entity(), pos, state, new AttachmentType[]{MachinesAttachments.Block.BalloonData.get()});
    }

    public void setRemoved() {
        BalloonStakeAttachment data = (BalloonStakeAttachment)this.getData(MachinesAttachments.Block.BalloonData);
        Level level = this.getLevel();
        if (level == null || level.isClientSide()) {
            return;
        }
        data.setIsBound(false);
        Player player = data.getPlayer(level);
        if (player != null) {
            data.setBoundId(-1);
            AttributeInstance creativeFlight = player.getAttribute(NeoForgeMod.CREATIVE_FLIGHT);
            if (creativeFlight != null && creativeFlight.hasModifier(BalloonStakeTickSystem.BalloonBoundID)) {
                creativeFlight.removeModifier(BalloonStakeTickSystem.InsideField);
                level.blockEntityChanged(this.getBlockPos());
            }
        }
        super.setRemoved();
    }

    public void onLoad() {
        super.onLoad();
        ((BalloonStakeAttachment)this.getData(MachinesAttachments.Block.BalloonData)).getPlayer(this.getLevel());
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        BalloonStakeAttachment data = (BalloonStakeAttachment)this.getData(MachinesAttachments.Block.BalloonData);
        if (data.isBound()) {
            data.setBoundId(-1);
            data.setIsBound(false);
            Level level = this.getLevel();
            if (level != null) {
                level.blockEntityChanged(this.getBlockPos());
            }
        }
    }
}

