/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.attachments;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.items.IItemHandler;
import tv.soaryn.xycraft.core.container.item.ItemContainer;
import tv.soaryn.xycraft.core.container.item.SimpleItemContainer;
import tv.soaryn.xycraft.core.ui.EmptyMenu;
import tv.soaryn.xycraft.core.utils.AttachmentUtils;
import tv.soaryn.xycraft.core.utils.FakePlayerUtils;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;

public class FabricatorAttachment {
    private static final Codec<FabricatorAttachment> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CodecUtils.Codecs.ITEM_STACK_OPTIONAL.listOf().fieldOf("items").forGetter(data -> data.Inventory.copyToList()), (App)Codec.INT.fieldOf("strict").forGetter(cacheData -> cacheData.MenuData.get(0)), (App)Codec.INT.fieldOf("mode").forGetter(cacheData -> cacheData.MenuData.get(1)), (App)Codec.BOOL.fieldOf("can_craft").forGetter(FabricatorAttachment::canCraft), (App)Codec.BOOL.fieldOf("prev_redstone").forGetter(FabricatorAttachment::prevRedstoneState), (App)UUIDUtil.CODEC.fieldOf("player_uuid").forGetter(FabricatorAttachment::playerId)).apply((Applicative)builder, FabricatorAttachment::new));
    public static final AttachmentType.Builder<FabricatorAttachment> BUILDER = AttachmentUtils.createBuilder(FabricatorAttachment::new, CODEC, (data, holder) -> {
        data._blockEntity = (BlockEntity)holder;
    });
    private final RecipeManager.CachedCheck<CraftingInput, CraftingRecipe> check = RecipeManager.createCheck((RecipeType)RecipeType.CRAFTING);
    public final ItemContainer Inventory = new SimpleItemContainer(19, this::setChanged);
    public final ItemContainer Storage = this.Inventory.slice(0, 9);
    public final ItemContainer Ghost = this.Inventory.slice(9, 19);
    public final SimpleContainerData MenuData = new SimpleContainerData(2);
    public final IItemHandler ItemHandler = this.Storage.asHandler();
    public Optional<RecipeHolder<CraftingRecipe>> RecipeCache = Optional.empty();
    private boolean _canCraft = true;
    private boolean _prevRedstone = false;
    private UUID _playerUuid = FakePlayerUtils.DEFAULT_UUID;
    private BlockEntity _blockEntity;

    private FabricatorAttachment(IAttachmentHolder holder) {
        if (holder instanceof BlockEntity) {
            BlockEntity entity;
            this._blockEntity = entity = (BlockEntity)holder;
        }
    }

    private FabricatorAttachment(List<ItemStack> inventory, int strict, int mode, boolean canCraft, boolean prevRedstone, UUID playerUuid) {
        for (int i = 0; i < inventory.size(); ++i) {
            this.Inventory.set(i, inventory.get(i));
        }
        this.MenuData.set(0, strict);
        this.MenuData.set(1, mode);
        this._canCraft = canCraft;
        this._prevRedstone = prevRedstone;
        this._playerUuid = playerUuid;
    }

    public void invalidateRecipeCache() {
        if (this._blockEntity == null) {
            return;
        }
        Level level = this._blockEntity.getLevel();
        if (level == null) {
            return;
        }
        CraftingContainer craftingContainer = FabricatorAttachment.createCraftingContainer(this.Ghost, 0);
        Optional<RecipeHolder<CraftingRecipe>> prev = this.RecipeCache;
        CraftingInput recipeInput = craftingContainer.asCraftInput();
        this.RecipeCache = this.check.getRecipeFor((RecipeInput)recipeInput, level);
        if (prev.equals(this.RecipeCache)) {
            return;
        }
        if (this.RecipeCache.isPresent()) {
            CraftingRecipe recipe = (CraftingRecipe)this.RecipeCache.get().value();
            this.Ghost.set(9, recipe.assemble((RecipeInput)recipeInput, (HolderLookup.Provider)level.registryAccess()));
        } else {
            this.Ghost.set(9, ItemStack.EMPTY);
        }
        this._blockEntity.setChanged();
        BlockPos pos = this._blockEntity.getBlockPos();
        BlockState state = this._blockEntity.getBlockState();
        level.markAndNotifyBlock(pos, level.getChunkAt(pos), state, state, 3, 512);
        level.sendBlockUpdated(pos, state, state, 11);
    }

    public static CraftingContainer createCraftingContainer(ItemContainer inventory, int offset) {
        TransientCraftingContainer craftingContainer = new TransientCraftingContainer((AbstractContainerMenu)new EmptyMenu(), 3, 3);
        for (int i = 0; i < 9; ++i) {
            craftingContainer.setItem(i, inventory.get(i + offset));
        }
        return craftingContainer;
    }

    public boolean canCraft() {
        return this._canCraft;
    }

    public boolean prevRedstoneState() {
        return this._prevRedstone;
    }

    public void setPrevRedstoneState(boolean value) {
        this._prevRedstone = value;
        this.setChanged();
    }

    public void setCanCraft(boolean canCraft) {
        this._canCraft = canCraft;
        this.setChanged();
    }

    private void setChanged() {
        if (this._blockEntity != null) {
            this._blockEntity.setChanged();
        }
    }

    public UUID playerId() {
        return this._playerUuid;
    }
}

