/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client.models;

import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.BakedModelWrapper;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.api.content.capabilities.PipeConnectionType;
import tv.soaryn.xycraft.machines.content.blocks.pipe.PipeBlockEntity;

public class PipeBakedModel
extends BakedModelWrapper<BakedModel> {
    private final List<BakedQuad>[] _cache = new List[4096];

    public PipeBakedModel(BakedModel core, Reference2ObjectMap<Direction.Axis, BakedModel> straight, Reference2ObjectOpenHashMap<Direction, BakedModel> _insert, Reference2ObjectOpenHashMap<Direction, BakedModel> extract, Reference2ObjectOpenHashMap<Direction, BakedModel> shortStraight, Reference2ObjectOpenHashMap<Direction, BakedModel> cap) {
        super(core);
        RandomSource random = RandomSource.create();
        int keyStraightX = PipeBlockEntity.makeModelKey(direction -> direction.getAxis() == Direction.Axis.X ? PipeConnectionType.Transfer : PipeConnectionType.None);
        int keyStraightY = PipeBlockEntity.makeModelKey(direction -> direction.getAxis() == Direction.Axis.Y ? PipeConnectionType.Transfer : PipeConnectionType.None);
        int keyStraightZ = PipeBlockEntity.makeModelKey(direction -> direction.getAxis() == Direction.Axis.Z ? PipeConnectionType.Transfer : PipeConnectionType.None);
        List<BakedQuad> c = PipeBakedModel.getAllQuads(core, random);
        IntStream.range(0, 4096).forEach(key -> {
            if (!straight.isEmpty() && key == keyStraightX) {
                this._cache[key] = PipeBakedModel.getAllQuads((BakedModel)straight.get((Object)Direction.Axis.X), random);
            } else if (!straight.isEmpty() && key == keyStraightY) {
                this._cache[key] = PipeBakedModel.getAllQuads((BakedModel)straight.get((Object)Direction.Axis.Y), random);
            } else if (!straight.isEmpty() && key == keyStraightZ) {
                this._cache[key] = PipeBakedModel.getAllQuads((BakedModel)straight.get((Object)Direction.Axis.Z), random);
            } else {
                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(c);
                for (Direction dir : Direction.values()) {
                    int conKey = key >> dir.ordinal() * 2 & 3;
                    PipeConnectionType con = PipeConnectionType.values()[conKey];
                    BakedModel model = switch (con) {
                        default -> throw new MatchException(null, null);
                        case PipeConnectionType.None -> (BakedModel)cap.get((Object)dir);
                        case PipeConnectionType.Insert -> (BakedModel)_insert.get((Object)dir);
                        case PipeConnectionType.Extract -> (BakedModel)extract.get((Object)dir);
                        case PipeConnectionType.Transfer -> (BakedModel)shortStraight.get((Object)dir);
                    };
                    quads.addAll(PipeBakedModel.getAllQuads(model, random));
                }
                this._cache[key] = quads;
            }
        });
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        if (side == null) {
            Integer data = (Integer)extraData.get(PipeBlockEntity.ModelPropKey);
            return this._cache[data == null ? 0 : data];
        }
        return List.of();
    }

    private static List<BakedQuad> getAllQuads(BakedModel model, RandomSource random) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(model.getQuads(null, null, random, ModelData.EMPTY, null));
        for (Direction dir : Direction.values()) {
            quads.addAll(model.getQuads(null, dir, random, ModelData.EMPTY, null));
        }
        return quads;
    }
}

