/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminalscompat.modcompat.rei.terminalstorage;

import dev.architectury.event.CompoundEventResult;
import java.util.Optional;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.registry.screen.FocusedStackProvider;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;

public class TerminalStorageReiFocusedStackProvider
implements FocusedStackProvider {
    public CompoundEventResult<EntryStack<?>> provide(Screen screen, Point point) {
        if (screen instanceof ContainerScreenTerminalStorage) {
            ContainerScreenTerminalStorage containerScreen = (ContainerScreenTerminalStorage)screen;
            return this.createClickableIngredient(containerScreen, point.x, point.y);
        }
        return CompoundEventResult.pass();
    }

    private <T> CompoundEventResult<EntryStack<?>> createClickableIngredient(ContainerScreenTerminalStorage<T, ?> containerScreen, int mouseX, int mouseY) {
        int slotIndex = containerScreen.getStorageSlotIndexAtPosition(mouseX, mouseY);
        Optional<TerminalStorageTabIngredientComponentClient> tabOptional = containerScreen.getSelectedClientTab().filter(TerminalStorageTabIngredientComponentClient.class::isInstance).map(TerminalStorageTabIngredientComponentClient.class::cast);
        if (slotIndex >= 0 && tabOptional.isPresent()) {
            TerminalStorageTabIngredientComponentClient tab = tabOptional.get();
            int channel = ((ContainerTerminalStorageBase)((Object)containerScreen.getMenu())).getSelectedChannel();
            Optional<Object> instanceOptional = tab.getSlotInstance(channel, slotIndex);
            return instanceOptional.map(instance -> {
                EntryStack entryStack;
                if (instance instanceof ItemStack) {
                    ItemStack itemStack = (ItemStack)instance;
                    entryStack = EntryStacks.of((ItemStack)itemStack);
                } else if (instance instanceof FluidStack) {
                    FluidStack fluidStack = (FluidStack)instance;
                    entryStack = EntryStacks.of((Fluid)fluidStack.getFluid(), (long)fluidStack.getAmount());
                } else {
                    entryStack = EntryStack.empty();
                }
                return CompoundEventResult.interruptTrue((Object)entryStack);
            }).orElse(CompoundEventResult.pass());
        }
        return CompoundEventResult.pass();
    }
}

