/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCrafting;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingOption;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;

public class TerminalStorageIngredientCraftingOptionsPacket
extends PacketCodec<TerminalStorageIngredientCraftingOptionsPacket> {
    public static final CustomPacketPayload.Type<TerminalStorageIngredientCraftingOptionsPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"integratedterminals", (String)"terminal_storage_ingredient_crafting_options"));
    public static final StreamCodec<RegistryFriendlyByteBuf, TerminalStorageIngredientCraftingOptionsPacket> CODEC = TerminalStorageIngredientCraftingOptionsPacket.getCodec(TerminalStorageIngredientCraftingOptionsPacket::new);
    @CodecField
    private String tabId;
    @CodecField
    private int channel;
    @CodecField
    private CompoundTag data;
    @CodecField
    private boolean reset;
    @CodecField
    private boolean firstChannel;
    @CodecField
    private String ingredientComponentName;

    public TerminalStorageIngredientCraftingOptionsPacket() {
        super(ID);
    }

    public <T> TerminalStorageIngredientCraftingOptionsPacket(HolderLookup.Provider lookupProvider, String tabId, int channel, Collection<HandlerWrappedTerminalCraftingOption<T>> craftingOptions, boolean reset, boolean firstChannel, IngredientComponent<?, ?> ingredientComponent) {
        super(ID);
        this.tabId = tabId;
        this.channel = channel;
        this.data = new CompoundTag();
        ListTag list = new ListTag();
        for (HandlerWrappedTerminalCraftingOption<T> option : craftingOptions) {
            list.add((Object)HandlerWrappedTerminalCraftingOption.serialize(lookupProvider, option));
        }
        this.data.put("craftingOptions", (Tag)list);
        this.reset = reset;
        this.firstChannel = firstChannel;
        this.ingredientComponentName = IngredientComponent.REGISTRY.getKey(ingredientComponent).toString();
    }

    public boolean isAsync() {
        return GeneralConfig.packetDeserializationEnableMultithreading;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
        IngredientComponent ingredientComponent = (IngredientComponent)IngredientComponent.REGISTRY.get(ResourceLocation.parse((String)this.ingredientComponentName));
        if (this.ingredientComponentName == null) {
            throw new IllegalArgumentException("Could not find the ingredient component type " + this.ingredientComponentName);
        }
        ListTag list = this.data.getList("craftingOptions", 10);
        ArrayList craftingOptions = Lists.newArrayListWithExpectedSize((int)list.size());
        for (int i = 0; i < list.size(); ++i) {
            HandlerWrappedTerminalCraftingOption option = HandlerWrappedTerminalCraftingOption.deserialize((HolderLookup.Provider)world.registryAccess(), ingredientComponent, list.getCompound(i));
            craftingOptions.add(option);
        }
        Minecraft.getInstance().execute(() -> {
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof ContainerTerminalStorageBase) {
                ContainerTerminalStorageBase container = (ContainerTerminalStorageBase)patt0$temp;
                TerminalStorageTabIngredientComponentClient tab = (TerminalStorageTabIngredientComponentClient)container.getTabClient(this.tabId);
                tab.addCraftingOptions(this.channel, craftingOptions, this.reset, this.firstChannel);
                if (this.tabId.equals(IngredientComponents.ITEMSTACK.getName().toString())) {
                    TerminalStorageTabIngredientComponentClient tabCrafting = (TerminalStorageTabIngredientComponentClient)container.getTabClient(TerminalStorageTabIngredientComponentItemStackCrafting.NAME.toString());
                    tabCrafting.addCraftingOptions(this.channel, craftingOptions, this.reset, this.firstChannel);
                }
                container.refreshChannelStrings();
            }
        });
    }

    public void actionServer(Level world, ServerPlayer player) {
    }
}

