/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.crafting;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingOption;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.TerminalStorageTabIngredientCraftingHandlers;

public class HandlerWrappedTerminalCraftingOption<T> {
    private final ITerminalStorageTabIngredientCraftingHandler handler;
    private final ITerminalCraftingOption<T> craftingOption;

    public HandlerWrappedTerminalCraftingOption(ITerminalStorageTabIngredientCraftingHandler handler, ITerminalCraftingOption<T> craftingOption) {
        this.handler = handler;
        this.craftingOption = craftingOption;
    }

    public ITerminalStorageTabIngredientCraftingHandler getHandler() {
        return this.handler;
    }

    public ITerminalCraftingOption<T> getCraftingOption() {
        return this.craftingOption;
    }

    public static <T> CompoundTag serialize(HolderLookup.Provider lookupProvider, HandlerWrappedTerminalCraftingOption<T> craftingOption) {
        ITerminalStorageTabIngredientCraftingHandler handler = craftingOption.getHandler();
        CompoundTag tag = handler.serializeCraftingOption(lookupProvider, craftingOption.getCraftingOption());
        tag.putString("craftingOptionHandler", handler.getId().toString());
        return tag;
    }

    public static <T, M> HandlerWrappedTerminalCraftingOption<T> deserialize(HolderLookup.Provider lookupProvider, IngredientComponent<T, M> ingredientComponent, CompoundTag tag) {
        if (!tag.contains("craftingOptionHandler", 8)) {
            throw new IllegalArgumentException("Could not find a craftingOptionHandler entry in the given tag");
        }
        String handlerId = tag.getString("craftingOptionHandler");
        ITerminalStorageTabIngredientCraftingHandler handler = TerminalStorageTabIngredientCraftingHandlers.REGISTRY.getHandler(ResourceLocation.parse((String)handlerId));
        Object craftingOption = handler.deserializeCraftingOption(lookupProvider, ingredientComponent, tag);
        return new HandlerWrappedTerminalCraftingOption<T>(handler, craftingOption);
    }
}

