/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.helper.transfer;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.swedz.tesseract.neoforge.helper.TransferHelper;
import net.swedz.tesseract.neoforge.helper.transfer.TransferCache;

public class FluidTransferCache
extends TransferCache<IFluidHandler> {
    public FluidTransferCache(BlockCapability<IFluidHandler, Direction> capability, Supplier<IFluidHandler> sourceHandler) {
        super(capability, sourceHandler);
    }

    public FluidTransferCache(Supplier<IFluidHandler> sourceHandler) {
        this((BlockCapability<IFluidHandler, Direction>)Capabilities.FluidHandler.BLOCK, sourceHandler);
    }

    @Override
    public boolean autoExtract(Level level, BlockPos pos, Direction direction) {
        IFluidHandler target = (IFluidHandler)this.cache.output(level, pos, direction);
        if (target != null) {
            return !TransferHelper.tryFluidTransfer((IFluidHandler)this.sourceHandler(), target, Integer.MAX_VALUE, false).isEmpty();
        }
        return false;
    }

    @Override
    public boolean autoInsert(Level level, BlockPos pos, Direction direction) {
        IFluidHandler target = (IFluidHandler)this.cache.input(level, pos, direction);
        if (target != null) {
            return !TransferHelper.tryFluidTransfer(target, (IFluidHandler)this.sourceHandler(), Integer.MAX_VALUE, false).isEmpty();
        }
        return false;
    }
}

